# -*- coding: utf-8 -*-
import csv
import os

from osgeo import ogr


# 파일 존재 여부 체크 함수
def ChFile_Exists(file):
    return os.path.exists(file)


def ChFile_N_MkDir(path):
    if not ChFile_Exists(path):
        os.makedirs(path)


# 파일 이름 받아오기 함수
def GetFile_Name(file):
    FileName = os.path.basename(file)
    return FileName


# 파일 경로 받아 오기(파일명 제외함)
def GetFileDirectory_Path(file):
    return os.path.dirname(file)


# 프로그램의 실행 경로를 받아옴
def GetScriptDirectory_Path():
    scriptDirectory = os.path.dirname(os.path.realpath(__file__))
    return scriptDirectory


# 파일 전체를 읽어서 파일 내용을 한번에 반환
def GetRead_Txt(file):
    f = open(file, "r")
    AllText = f.read()
    f.close()
    return AllText


def GetFileType(filename):
    return os.path.splitext(filename)[1]


# 지정 폴더의 하위 내용을 읽어 파일 리스트 반환
def GetSubFolder_List(targetFolder, extension=""):
    fileList = []

    for path, dirs, files in os.walk(targetFolder):
        if files:  # 빈값인지 확인 가능
            if extension:
                exten = extension.split(", ")
                l = [
                    os.path.join(path, fileName)
                    for fileName in files
                    for e in exten
                    if fileName.endswith(e)
                ]
            else:
                l = [os.path.join(path, fileName) for fileName in files]

            fileList += l

    return fileList


# 2019-10-22 shp 파일의 column 이름을 가져옴
def GetShpColumnList(filePath):
    ds = ogr.Open(filePath)
    lyr = ds.GetLayer()
    fieldNames = [field.name for field in lyr.schema]
    return fieldNames


def GetShpColumnData(filePath, colName, distict=True):
    driver = ogr.GetDriverByName("ESRI Shapefile")
    ds = driver.Open(filePath)
    lyr = ds.GetLayer()

    fields = [f.GetField(colName) for f in lyr]
    if distict:
        fields = list(set(fields))
    return fields


def GetShpProj4(filePath):
    driver = ogr.GetDriverByName("ESRI Shapefile")
    shape = driver.Open(filePath)
    layer = shape.GetLayer()
    crs = layer.GetSpatialRef()
    proj4 = crs.ExportToProj4() if crs else ""
    return proj4


def GetCSVContent_List(filePath, headerFlag=False):
    contents = []
    f = None
    try:
        f = open(filePath, "r", encoding="cp949")
    except UnicodeDecodeError:
        f = open(filePath, "r", encoding="utf-8")
    finally:
        if f is not None:
            rdr = csv.reader(f)
            for line in rdr:
                repLine = [
                    l.replace(",", "")
                    if l.replace(",", "").replace(".", "").isdigit()
                    else l
                    for l in line
                ]
                contents.append(repLine)
            f.close()

    return contents


def RemoveFolderInFiles(folderPath):
    fileList = GetSubFolder_List(folderPath)
    for files in fileList:
        os.remove(files)
