# -*- coding: utf-8 -*-
import os
import tempfile
from subprocess import Popen

from qgis.PyQt.QtWidgets import QFileDialog, QMessageBox


# 메시지 박스 타이틀 일괄 적용 하기
# 미리 한번 호출해서 값 셋팅
def MsTitle(name, msgParent=None):
    global parent, title
    parent = msgParent
    title = name


def MsInfo(mess):
    QMessageBox.information(parent, title, str(mess))


def MsError(mess):
    #     exc_type, exc_obj, exc_tb = sys.exc_info()
    #     mess = f"({exc_type}, {exc_tb.tb_lineno}) {mess}"
    QMessageBox.warning(parent, title, str(mess))


# 2019-10-17 추가
def MsQuestion(mess):
    ret = QMessageBox.question(parent, title, mess, QMessageBox.Yes | QMessageBox.No)
    result = True if ret == QMessageBox.Yes else False
    return result


# 파일 다이얼 로그는 각자 만들어 쓰는게 편할지도... 임시로 만들어 둠
def OpenFileDialog(txtbox, filetype):
    fname = QFileDialog.getOpenFileName(parent, "Open file-" + title, "", filetype)
    txtbox.setText(str(fname[0]))


def OpenFilesDialog(filetype):
    fnames = QFileDialog.getOpenFileNames(parent, "Open file-" + title, "", filetype)
    return fnames


def SaveFileDialog(txtbox, filetype):
    fname = QFileDialog.getSaveFileName(parent, "Save file-" + title, "", filetype)
    txtbox.setText(str(fname[0]))


def FolderDialog(txtbox, kind):
    fpath = QFileDialog.getExistingDirectory(parent, kind + " folder-" + title, "")
    txtbox.setText(fpath)


def callExecute(arg):
    result = Popen(arg, shell=True)
    return result.communicate()


def makeTempFile(tmpFoler, fileType):
    if not os.path.exists(tmpFoler):
        os.mkdir(tmpFoler)
    rpath = tempfile.NamedTemporaryFile(suffix=fileType, dir=tmpFoler).name
    return rpath
