from qgis.PyQt.QtWidgets import QAbstractItemView, QTreeView


class LayerLegendTool(QTreeView):
    def __init__(self, wig, parent=None):
        super(LayerLegendTool, self).__init__(parent)
        layout = wig.widget(1).layout()
        layout.addWidget(self, 3, 1, 2, 4)

        self.setDragEnabled(True)  # 드래그 해서 레이어 순서 변경
        self.setDragDropMode(QAbstractItemView.DragDrop)

    def dropEvent(self, event):  # QDropEvent
        self.setDragDropMode(QAbstractItemView.InternalMove)
        QTreeView.dropEvent(self, event)
        self.setDragDropMode(QAbstractItemView.DragDrop)
