
create table if not exists building_costs (
	occupancy char(30),    
	description char(15),
    costs int,
    primary key ("occupancy", "description")
);

create table if not exists building_csvr (
    occupancy char(30),
    csvr real,
    primary key ("occupancy")
);

create table if not exists building_entrance (
    occupancy char(30),
    height real,
    primary key ("occupancy")
);

create table if not exists building_depreciation (
	occupancy char(30),    
	description char(15),
    persisting_period real,
    primary key ("occupancy", "description")
);

create table if not exists vehicle_costs (
    type char(6),
    costs integer,
	primary key ("type")
);

create table if not exists vehicle_salvage_rate_new (
    type character(6),
    rate real,
	primary key ("type")
);

create table if not exists population_unit_cost (
	year int,
	life_loss int,
	victim_loss int,
	primary key ("year")
);

create table if not exists agriculture_unit_price (
	farmland char(5) NOT NULL,
	crops char(9) not null,
	input_prd_cst real, 
	expct_netpr real
);

create table if not exists agriculture_unit_cost (
	unit real
);

create table if not exists building_structure_damage_rate (
	occupancy char(30), 
	description char(15),
	"0" real,	"1" real,    "2" real,    "3" real,    "4" real,
    "5" real,    "6" real,    "7" real,    "8" real,
    "9" real,    "10" real,    "11" real,
	primary key ("occupancy", "description")
);

create table if not exists building_inner_damage_rate (
	occupancy char(30), 
	"0" real,	"1" real,    "2" real,    "3" real,    "4" real,
    "5" real,    "6" real,    "7" real,    "8" real,
    "9" real,    "10" real,    "11" real,
	primary key ("occupancy")
);

create table if not exists vehicle_dmg_func (
	"type" text, 
	"0" real,	"1" real,    "2" real,    "3" real,    "4" real,
    "5" real,    "6" real,    "7" real,    "8" real,
    "9" real,    "10" real,    "11" real,
    primary key ("type")
);

create table if not exists population_life_loss (
	hierarchy text,
	"0" real,	"1" real,    "2" real,    "3" real,    "4" real,
    "5" real,    "6" real,    "7" real,    "8" real,
    "9" real,    "10" real,    "11" real,
	primary key ("hierarchy")
);

create table if not exists population_victim_loss (
	hierarchy text,
	"0" real,	"1" real,    "2" real,    "3" real,    "4" real,
    "5" real,    "6" real,    "7" real,    "8" real,
    "9" real,    "10" real,    "11" real,
	primary key ("hierarchy")
);

create table if not exists agriculture_crop_dmg_func (
	farmland character(5) NOT NULL,
	crops character(9) NOT null,
	"0" real,	"1" real,    "2" real,    "3" real,    "4" real,
    "5" real,    "6" real,    "7" real,    "8" real,
    "9" real,    "10" real,    "11" real,
	primary key (farmland, crops)
);

create table if not exists agriculture_frm_dmg_func (
	farmland character(5) NOT NULL,
	"0" real,	"1" real,    "2" real,    "3" real,    "4" real,
    "5" real,    "6" real,    "7" real,    "8" real,
    "9" real,    "10" real,    "11" real,
	primary key (farmland)
);


create table if not exists flood_table_list (
	path text, --파일 경로
	frequency int, --홍수 빈도
	comment text,
	table_name text, --테이블 명
	flood_column text, --침수 필드 명
	area text, --침수 구역도 해당 지역
	sig_cd text, --시군구 코드
	area_count text --침수 구역도 순서?
);

create table if not exists flood_sum_result(
	table_name text,
	type text, 
	building_res real, 
	building_non_res real, 
	vehicle real, 
	life real, 
	victim real, 
	crop real, 
	farmland real, 
	sum real
);

create table if not exists reclass_field_table(
	ogc_fid int not null,
	code text not null,
	min real not null, 
	max real not null,
	primary key (ogc_fid, code)
);

create table if not exists public_loss_coefficient(
	value double
);

create table if not exists annualized_loss(
	rank int,
	flood text,
	frequency int,
	private_sector double, 
	public_sector double,
	total double,
	probability double,
	average double,
	annual double,
	cumulative double,
	primary key (flood)
);
