DROP TABLE IF EXISTS inv_building;
create table if not exists inv_building (
	OGC_FID INTEGER PRIMARY KEY,
    L_ADMIN VARCHAR(255),
    S_BDTYP VARCHAR(255),
    BDTYP VARCHAR(255),
    S_BDSTR VARCHAR(255),
    BDSTR VARCHAR(255),
    BD_F_AREA REAL,
    GRO_FLO_CO REAL,
    UND_FLO_CD REAL,
    RA_USE_YEAR CHER(8),
    USE_YEAR CHAR(4), 
    SIG_CD CHAR(5),
    EMD_CD CHAR(3),
    LI_CD CHAR(2),
    MNTN_YN CHAR(1),
    LNBR_MNNM CHAR(4),
    LNBR_SLNO CHAR(4),
    BULD_NM_DC VARCHAR(255),
    MAT_RES VARCHAR(255), 
    GEOMETRY MULTYPOLYGON
);

DROP TABLE IF EXISTS inv_farmland;
CREATE TABLE IF NOT EXISTS inv_farmland (
    OGC_FID INTEGER,
	ID VARCHAR(50),
    LAND_CODE CHAR(4),
    SHAP_AREA REAL,
    PNU CHAR(19),
    PNU10 CHAR(10),
    L_ADMIN VARCHAR,
    PAD_AREA REAL,
    FRU_AREA REAL,
    GRE_AREA REAL,
    GIN_AREA REAL,
    UPL_SES REAL,
    UPL_WAM REAL,
    UPL_RAP REAL,
    UPL_CAB REAL,
    UPL_COR REAL,
    UPL_SOY REAL,
    UPL_SWP REAL,
    SUM_AREA REAL, 
    GEOMETRY MULTYPOLYGON,
    primary key (ogc_fid, id)
);

DROP TABLE IF EXISTS inv_population;
CREATE TABLE IF NOT EXISTS inv_population (
    OGC_FID INTEGER,
    BASE_YEAR CHAR(4),
    SIG_CD CHAR(5),
    EMD_CD CHAR(3),
    L_ADMIN VARCHAR(255),
    TOT_REG_CD CHAR(13) PRIMARY KEY NOT NULL,
    TOT_POP NUMERIC,
    VUL_POP NUMERIC,
    GEN_POP NUMERIC, 
    GEOMETRY MULTYPOLYGON
);

DROP TABLE IF EXISTS inv_car;
CREATE TABLE IF NOT EXISTS inv_car (
    OGC_FID INTEGER,
    BASE_YEAR CHAR(4),
    SIG_CD CHAR(5),
    EMD_CD CHAR(3),
    L_ADMIN VARCHAR(255),
    TOT_REG_CD CHAR(13) PRIMARY KEY NOT NULL,
    T1_N NUMERIC,
    T2_N NUMERIC,
    T3_N NUMERIC,
    T1_C NUMERIC,
    T2_C NUMERIC,
    T3_C NUMERIC, 
    GEOMETRY MULTYPOLYGON
);