# -*- coding: utf-8 -*-
from kfrm_tool.include.File_Class import ChFile_Exists, GetShpColumnList


class ErrorConfirm:
    # 파일을 선택하는 곳에서 경로가 비어있거나, 존재하지 않는 경로일 경우 에러.
    def filePathErrorConfirm(self, filePath, msg=""):
        if filePath.strip() == "":
            msg = msg if msg else "No path was specified."
            raise Warning(msg)

        if not ChFile_Exists(filePath):
            msg = msg if msg else "The path specified is not valid."
            raise Warning(msg)

    def notTableSelectetConfirm(self, tbl):
        msg = "All information required for the calculation has not been entered."
        rowCount, colCount = self.tableEmptyConfirm(tbl, msg)
        for r in range(rowCount):
            for c in range(colCount):
                item = tbl.item(r, c)
                if not item or not item.text():
                    detail_msg = (
                        f"Please check {tbl.horizontalHeaderItem(c).text()} section."
                    )
                    raise Warning(msg + f"\n{detail_msg}")

    def notTableOneWidgetConfirm(
        self, tbl, colIndex, msg="Map name has not been entered."
    ):
        rowCount = tbl.rowCount()
        for r in range(rowCount):
            items = tbl.cellWidget(r, colIndex)
            if not items or not items.text().strip():
                raise Warning(msg)

    def listOverlapConfirm(self, target, msg=""):
        msg = (
            "Cannot use duplicate names. \nPlease change the frequency value or map name value."
            if not msg
            else msg
        )
        origin = len(target)
        confirm = len(list(set(target)))
        if origin != confirm:
            raise Warning(msg)

    def canvasEmptyConfirm(self, canvas):
        if not canvas.layers():
            raise Warning("The hazard map is not loaded.")

    def notSelectComboIndex(self, cmb, msg, cnt=0):
        if cmb.currentIndex() <= cnt:
            raise Warning(f"{msg} is not selected.")

    def noneSelectedType(self, typeList, msg="No save data format was specified."):
        if True not in typeList:
            raise Warning(msg)

    def tableEmptyConfirm(self, tbl, msg="The file is not exist.", toggle=True):
        rowCount = tbl.rowCount()
        colCount = tbl.columnCount()

        if toggle and (not rowCount or not colCount):
            raise Warning(msg)

        return rowCount, colCount

    def lossNoneDataTables(self, contentList):
        if not contentList:
            raise Warning("Flood data is not loaded.")
        elif not contentList[0][1]:
            raise Warning("The add map process was not performed.")

    def noneResultListData(self, conList, msg=""):
        msg = msg if msg else "The result data to be exported does not exist."
        if not conList:
            raise Warning(msg)

    def confirmComboCount(self, cmb, msg="File data to be loaded does not exist."):
        if cmb.count() < 1:
            raise Warning("")

    def confirmValueData(self, value, valueFlag=True, msg=""):
        msg = msg if msg else "This is not a valid value."
        if not value:
            raise Warning(msg)

        if valueFlag:
            values = value.text().replace(" ", "").split("-")
            if (
                len(values) < 2
                or (
                    values[0].replace(" ", "") != ""
                    and not values[0].replace(".", "").isdigit()
                )
                or (
                    values[1].replace(" ", "") != ""
                    and not values[1].replace(".", "").isdigit()
                )
            ):
                raise Warning("This is not a valid value.")

    def columnMatchError(self, tableColumn, insertColumn):
        if len(tableColumn) != len(insertColumn):
            raise Warning("Wrong type of data.")

    def columnInList(self, path, colName, msg=""):
        msg = msg if msg else f'"{colName}" does not exist in some SHP files.'
        if colName not in GetShpColumnList(path):
            raise Warning(msg)

    def notInSHPField(self, shpLayer, field):
        index = shpLayer.fields().lookupField("no")
        if index < 0:
            raise Warning(f'The selected layer does not have an "{field}" field.')

    def listComparison(self, listA, listB, msg=""):
        msg = msg if msg else "Changed data has not been applied."
        for a in listA:
            for b in listB:
                if a[0] == b[0] and a[1] != b[1]:
                    raise Warning(msg)
