# -*- coding: utf-8 -*-
"""
/***************************************************************************
 KRMDialog
                                 A QGIS plugin

 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-10-14
        git sha              : $Format:%H$
        copyright            : (C) 2019 by KICT, Hermesys
        email                : shpark@hermesys.co.kr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""

from qgis.PyQt.QtCore import QSize, Qt
from qgis.PyQt.QtWidgets import QDialog, QLineEdit

from kfrm_tool.include.db.db_connection import PostgreSQLConnection
from kfrm_tool.include.setting.logger import KFRMLogger
from kfrm_tool.include.setting.name_list import BASE_GEOSERVER
from kfrm_tool.include.Util import MsError, MsTitle
from kfrm_tool.user_login_dialog_base import Ui_Dialog as UserLoginDialogBase


class UserLogin(QDialog):
    def __init__(self, parent=None):
        """Constructor."""
        super(UserLogin, self).__init__(parent)

        self.ui = UserLoginDialogBase()
        self.ui.setupUi(self)

        KFRMLogger.info("KRMDialog: __init__")
        self.setWindowTitle("User Login")
        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint)

        self.ui.txt_inputPw.setEchoMode(QLineEdit.Password)

        self.ui.btn_adminLogin.clicked.connect(self.run)
        self.ui.btn_cancel.clicked.connect(self.close)

        MsTitle("KRM Tool Login", self)
        self.pg = PostgreSQLConnection()
        self.loginFlag = False
        self.loginType = False  # False=general /  True=pro

        self.ui.rdo_general.setChecked(True)
        self.radioCheckedEvent()
        self.ui.rdo_general.toggled.connect(self.radioCheckedEvent)
        self.ui.rdo_pro.toggled.connect(self.radioCheckedEvent)

        KFRMLogger.info("Geoserver URL: " + BASE_GEOSERVER)

    def radioCheckedEvent(self):
        WIDTH = 327
        HEIGHT_WITH_LOGIN = 138
        HEIGHT_WITHOUT_LOGIN = 69

        is_checked_pro_user = self.ui.rdo_pro.isChecked()
        HEIGHT = HEIGHT_WITH_LOGIN if is_checked_pro_user else HEIGHT_WITHOUT_LOGIN

        login_widget_list = [
            self.ui.label_3,
            self.ui.txt_inputHost,
            self.ui.label_2,
            self.ui.txt_inputPw,
        ]
        for w in login_widget_list:
            w.setVisible(is_checked_pro_user)

        self.setFixedSize(QSize(WIDTH, HEIGHT))

    def run(self):
        try:
            if self.ui.rdo_pro.isChecked():
                pw = self.ui.txt_inputPw.text()
                host = self.ui.txt_inputHost.text()
                self.pg.setPw(pw)
                self.pg.setHost(host)

                self.pg.connectionDB()
                self.loginType = "P"

            self.loginFlag = True
            self.close()
        except Exception as e:
            KFRMLogger.exception("user_login_dialog.py:run()")
            MsError(e)
