# geoserver 관련
BASE_GEOSERVER = "https://kfrm.hermesys.co.kr/geoserver/krm_geoserver/ows?"

# 기타
DATA_YEARS = "data_years"
BASE_GRID = "base_grid_500m"

# SQLite에 저장될 테이블이름들
LAYER_FLOOD = "flood_table_list"
RECLASS_TABLE = "reclass_field_table"
PRINT_HEADER = "inv_print_header_name_table"

# 침수지 shp, 결과 저장용
T_FLOOD = "flood_area"  # 침수 구역도
F_RESULT = "flood_sum_result"
PUB_LOSS = "public_loss_coefficient"
ANNU_LOSS = "annualized_loss"

# Building 관련
INV_BUILDING = "inv_building"  # 건물 인벤토리
B_ENTRACE = "building_entrance"  # 출입구 높이 값
B_DEPRECIATION = "building_depreciation"  # 감가상각률 값
B_COSTS = "building_costs"  # 건물단가 값
B_CSVR = "building_csvr"  # csvr 값
B_SDAMAGE = "building_structure_damage_rate"  # 건물 구조 손상률 값
B_IDAMAGE = "building_inner_damage_rate"  # 건물 내부 손상률 값
B_VALUE = "building_valuation_result"

# Population 관련
INV_POPULATION = "inv_population"
P_LIFE = "population_life_loss"
P_VICTIM = "population_victim_loss"
P_COSTS = "population_unit_cost"


# Farmland 관련
INV_FARMLAND = "inv_agriculture"
A_CDAMAGE = "agriculture_crop_dmg_func"
A_FDAMAGE = "agriculture_frm_dmg_func"
A_PRIFLOW = "agriculture_unit_price"
A_DUNIT = "agriculture_unit_cost"


# Vehicle 관련
INV_VEHICLE = "inv_vehicle"
V_COSTS = "vehicle_costs"
V_SALVAGE = "vehicle_salvage_rate_new"
V_VULFUNC = "vehicle_dmg_func"

# python 코드 dic 이름 관련
B_PARAM = "building parameter"
B_SUMRIZ = "building summarize"
B_VUL = "building vulnerability"
P_PARAM = "population parameter"
P_VUL = "population vulnerability"
A_PARAM = "agriculture parameter"
A_VUL = "agriculture vulnerability"
A_SUMRIZ = "agriculture summarize"
V_PARAM = "vehicle parameter"
V_SUMRIZ = "vehicle summarize"
V_VUL = "vehicle vulnerability"

# tableHeader 관련
h_dmg_func = [
    "0m",
    "0-0.3m",
    "0.3-0.6m",
    "0.6-0.9m",
    "0.9-1.2m",
    "1.2-1.5m",
    "1.5-1.8m",
    "1.8-2.1m",
    "2.1-2.4m",
    "2.4-2.7m",
    "2.7-3.0m",
    "3.0m-",
]
TABLE_HEADER_DIC = {
    B_COSTS: ["Occupancy", "Description", "Costs (1,000KW/㎡)"],
    B_CSVR: ["Occupancy", "CSVR (%)"],
    B_DEPRECIATION: ["Occupancy", "Description", "Persisting Period (yr)"],
    B_ENTRACE: ["Occupancy", "First Floor Elevation (m)"],
    B_IDAMAGE: ["Occupancy"] + h_dmg_func,
    B_SDAMAGE: ["Occupancy", "Description"] + h_dmg_func,
    V_COSTS: ["Sub-type", "Costs (1,000KW)"],
    V_SALVAGE: ["Sub-type", "Salvage Rate (%)"],
    P_LIFE: ["Hierarchy"] + h_dmg_func,
    P_VICTIM: ["Hierarchy"] + h_dmg_func,
    A_CDAMAGE: ["Farmland", "Crops"] + h_dmg_func,
    A_FDAMAGE: ["Farmland"] + h_dmg_func,
    #     A_MPRIFLOW : ['Farmland', 'Crops', 'May', 'Jun', 'Jul', 'Aug'],
    A_PRIFLOW: ["Farmland", "Crops", "input_prd_cst", "expct_netpr"],
    #     A_PRIFLOW : ['Farmland', 'Crops', 'stndr_prd_cst', 'stndr_income', 'input_prd_cst', 'expct_netpr'],
    V_VULFUNC: ["Type"] + h_dmg_func,
}

# parameter setting 관련
PARAM_INDEX = {
    B_PARAM: {
        "INDEX": 0,
        B_COSTS: [
            0,
            2,
            1,
        ],  # comboBox 순서 index, table에 표시되는 parameter 값이 시작되는 index, decimal Point
        B_CSVR: [1, 1, 1],
        B_DEPRECIATION: [2, 2, 1],
        B_ENTRACE: [3, 1, 1],
    },
    B_VUL: {"INDEX": 1, B_SDAMAGE: [4, 2, 1], B_IDAMAGE: [5, 1, 1]},
    V_PARAM: {"INDEX": 2, V_COSTS: [6, 1, 0], V_SALVAGE: [7, 1, 2]},
    V_VUL: {"INDEX": 3, V_VULFUNC: [8, 1, 1]},
    P_VUL: {"INDEX": 4, P_LIFE: [9, 1, 6], P_VICTIM: [10, 1, 6]},
    A_PARAM: {"INDEX": 5, A_PRIFLOW: [11, 2, 2]},
    A_VUL: {"INDEX": 6, A_CDAMAGE: [12, 2, 1], A_FDAMAGE: [13, 1, 1]},
}

# 농업 인벤토리에 있는 필드 종류
CROP_KINDS = {
    "pad": "논, 논벼",
    "fru": "과수, 과수",
    "gre": "시설, 딸기",
    "gin": "인삼, 인삼",
    "unf": "비경지, 비경지",
    "ses": "밭, 참깨",
    "wam": "밭, 수박",
    "rad": "밭, 가을무",
    "cab": "밭, 가을배추",
    "cor": "밭, 옥수수",
    "soy": "밭, 콩",
    "swp": "밭, 고구마",
}
