from qgis.core import QgsApplication

from kfrm_tool.include.File_Class import GetScriptDirectory_Path


# 실행 파일이나 설치 디렉토리 경로를 모아둔 클래스
class DefaultPath:
    def __init__(self):
        self.qgsApp = QgsApplication.instance()

    # Qgis App 경로
    def getQgisAppDirPath(self):
        return self.qgsApp.applicationDirPath()

    # Qgis 설치 경로
    def getQgisInstallPath(self):
        return self.getQgisAppDirPath() + "/.."

    # Qgis plugin 경로
    def getQgisPluginPath(self):
        return GetScriptDirectory_Path() + "/.."

    # Ogr2ogr.exe 파일 경로
    def getOgr2ogrPath(self):
        return self.getQgisAppDirPath() + "/ogr2ogr.exe"

    def getCheckIconPath(self):
        return self.getQgisPluginPath() + "/icon/check_icon.png"

    # 초기화 상태의 Sqlite DB 파일 경로
    def getEmptySqliteDBPath(self):
        return self.getQgisPluginPath() + "/include/db/sqlite/EmptyDB.sqlite"

    # 사용 Sqlite DB 파일 경로
    def getSqliteDBPath(self):
        return self.getQgisPluginPath() + "/include/db/sqlite/SQLiteDB.sqlite"

    # Spatialite DB를 사용하기 위한 Dll 파일 경로
    def getSpatialDllPath(self):
        return self.getQgisPluginPath() + "/include/db/sqlite/mod_spatialite.dll"

    # Sqlite create 문구가 적힌 sql 파일 경로
    def getSpatialSqlPath(self):
        return self.getQgisPluginPath() + "/include/db/sql/sqlite_create.sql"

    def getSpatialInvenSqlPath(self):
        return self.getQgisPluginPath() + "/include/db/sql/sqlite_inventory.sql"

    # SAGA exe 실행파일 경로
    def getSagaPath(self):
        return self.getQgisInstallPath() + "/apps/saga-ltr/saga_cmd.exe"

    # Osgeo.exe 실행파일 경로
    def getOsgeoPath(self):
        return self.getQgisInstallPath() + "/OSGeo4W.bat"

    def getTempPath(self):
        return self.getQgisPluginPath() + "/temp"
