# -*- coding: utf-8 -*-

import os
import sys
#from ElementTree import Element,ElementTree ,SubElement,dump,parse,tostring

from xml.etree.ElementTree import *


class Make:
    def __init__(self):
       self.ProjectFile = ""

    # New Project 시에 G2P 파일 생성 하기 기본값은 셋팅함 
    def Make_G2P_File(self,save_g2p_path):
        Project = Element("projectds")
        Project.set("xmlns","http://tempuri.org/projectds.xsd")
        ProjectSettings = SubElement(Project,"ProjectSettings")
        SubElement(ProjectSettings,'DEMFile').text = ''
        #SubElement(ProjectSettings,'DomainFile').text = ''
        SubElement(ProjectSettings,'LandCoverFile').text = ''
        SubElement(ProjectSettings,'LandCoverVatFile').text = ''
        SubElement(ProjectSettings,'CalculationTimeInterval_sec').text = '0.1'
        SubElement(ProjectSettings,'IsFixedDT').text = 'false'
        #SubElement(ProjectSettings,'IsParallel').text = 'true'
        SubElement(ProjectSettings,'MaxDegreeOfParallelismCPU').text = '10'
        SubElement(ProjectSettings,'UsingGPU').text = 'false'
        SubElement(ProjectSettings,'ThreadsPerBlock').text = '512'

        SubElement(ProjectSettings,'MaxIterationAllCells').text = '7'
        SubElement(ProjectSettings,'MaxIterationACell').text = '5'

        SubElement(ProjectSettings,'SimulationDuration_hr').text = '25'
        SubElement(ProjectSettings,'PrintoutInterval_min').text = '10'
        SubElement(ProjectSettings,'StartDateTime').text = '0'
        SubElement(ProjectSettings,'RainfallDataType').text = 'TextFileMAP'
        SubElement(ProjectSettings,'RainfallDataInterval_min').text = '10'
        SubElement(ProjectSettings,'InitialRainfallLoss_mm').text = '0.0'
        SubElement(ProjectSettings,'RainfallFile').text = ''
        SubElement(ProjectSettings,'BCDataInterval_min').text = '10'

        SubElement(ProjectSettings,'FloodingCellDepthThresholds_cm').text = ''
        SubElement(ProjectSettings,'CellLocationsToPrint').text = ''

        SubElement(ProjectSettings,'MakeASCFile').text = 'true'
        SubElement(ProjectSettings,'MakeImgFile').text = 'true'

        SubElement(ProjectSettings,'OutputDepth').text = 'true'
        SubElement(ProjectSettings,'OutputWaterLevel').text = 'false'
        SubElement(ProjectSettings,'OutputVelocityMax').text = 'false'
        SubElement(ProjectSettings,'OutputFDofMaxV').text = 'false'
        SubElement(ProjectSettings,'OutputDischargeMax').text = 'false'
        #SubElement(ProjectSettings,'OutputBCData').text = 'false'
        #SubElement(ProjectSettings,'OutputRFGrid').text = 'false'
        #SubElement(ProjectSettings,'OutputSinkData').text = 'false'
        #SubElement(ProjectSettings,'OutputSourceAll').text = 'false'        

        SubElement(ProjectSettings,'DepthImgRendererMaxV').text = '5'
        SubElement(ProjectSettings,'WaterLevelimgRendererMaxV').text = '200'
        SubElement(ProjectSettings,'VelocityMaxImgRendererMaxV').text = '10'
        SubElement(ProjectSettings,'DischargeImgRendererMaxV').text = '10000'
        #SubElement(ProjectSettings,'RFImgRendererMaxV').text = '30'

        SubElement(ProjectSettings,'OutputPrecision_Depth').text = '5'
        SubElement(ProjectSettings,'OutputPrecision_WaterLevel').text = '5'
        SubElement(ProjectSettings,'OutputPrecision_VelocityMax').text = '5'
        SubElement(ProjectSettings,'OutputPrecision_DischargeMax').text = '2'

        SubElement(ProjectSettings,'WriteLog').text = 'false'

        HydroPars = SubElement(Project,"HydroPars")
        #2019-10-10 박: 최박사님 기본값 변경 요청건
        #SubElement(HydroPars,'RoughnessCoeff').text = '0.03'
        SubElement(HydroPars,'RoughnessCoeff').text = '0.045'
        SubElement(HydroPars,'DomainOutBedSlope').text = '0.001'
        #SubElement(HydroPars,'ImperviousRatio').text = '1'

        #2019-20-20 박: InitialDepth 삭제 InitialConditionType,InitialCondition 추가
        #SubElement(HydroPars,'InitialDepth').text = '0'
        SubElement(HydroPars,'InitialConditionType').text = 'Depth'
        SubElement(HydroPars,'InitialCondition').text = '0'


        SubElement(HydroPars,'FroudeNumberCriteria').text = '1'
        SubElement(HydroPars,'CourantNumber').text = '0.7'
        SubElement(HydroPars,'ApplyVNC').text = 'false'

        # 기능 테스트용
        #DEMFileToChange = SubElement(Project,"DEMFileToChange")
        #SubElement(DEMFileToChange,'TimeMinute').text = '60'
        #SubElement(DEMFileToChange,'DEMFile').text = 'C:/Users/hermesys/Desktop/qazw.g2p'

        #DEMFileToChange = SubElement(Project,"DEMFileToChange")
        #SubElement(DEMFileToChange,'TimeMinute').text = '60'
        #SubElement(DEMFileToChange,'DEMFile').text = 'C:/Users/hermesys/Desktop/qazw.g2p'

        #BoundaryConditionData = SubElement(Project,"BoundaryConditionData")
        #SubElement(BoundaryConditionData,'CellXY1').text = '10,10'
        #SubElement(BoundaryConditionData,'CellXY2').text = '10,10'
        #SubElement(BoundaryConditionData,'CellXY3').text = '10,10'
        #SubElement(BoundaryConditionData,'CellXY4').text = '10,10'
        #SubElement(BoundaryConditionData,'DataFile').text = 'C:/Users/hermesys/Desktop/qazw.g2p'
        #SubElement(BoundaryConditionData,'DataType').text = 'C:/Users/hermesys/Desktop/qazw.g2p'

        #BoundaryConditionData = SubElement(Project,"BoundaryConditionData")
        #SubElement(BoundaryConditionData,'CellXY1').text = '10,10'
        #SubElement(BoundaryConditionData,'CellXY2').text = '10,10'
        #SubElement(BoundaryConditionData,'CellXY3').text = '10,10'
        #SubElement(BoundaryConditionData,'CellXY4').text = '10,10'
        #SubElement(BoundaryConditionData,'DataFile').text = 'C:/Users/hermesys/Desktop/qazw.g2p'
        #SubElement(BoundaryConditionData,'DataType').text = 'C:/Users/hermesys/Desktop/qazw.g2p'




        ElementTree(Project).write(save_g2p_path,encoding="utf-8",xml_declaration=True)
