# -*- coding: utf-8 -*-
import os
import sys
import glob
import fnmatch
from subprocess import call

from qgis.core import QgsApplication
from PyQt5.QtWidgets import *

from .File_Class import *


# 메시지 박스 타이틀 일괄 적용 하기
# 미리 한번 호출해서 값 셋팅
def MsTitle(name):
    global title
    title = name

def MsInfo(mess):
    QMessageBox.information(None, title, str(mess)) 

def MsError(mess):
    QMessageBox.warning(None,title, str(mess))

# 파일 다이얼 로그는 각자 만들어 쓰는게 편할지도... 임시로 만들어 둠    
def OpenFileDialog(txtbox,filetype):
    fname = QFileDialog.getOpenFileName(None, 'Open file-' + title ,'',filetype)
    txtbox.setText(str(fname[0]))

# 파일 다이얼 로그는 각자 만들어 쓰는게 편할지도... 임시로 만들어 둠    
def OpenFileDialog(filetype):
    fname = QFileDialog.getOpenFileName(None, 'Open file-' + title ,'',filetype)
    return str(fname[0])

# 파일 다이얼 로그는 각자 만들어 쓰는게 편할지도... 임시로 만들어 둠    
def OpenFilesDialog(filetype):
    fnames = QFileDialog.getOpenFileNames(None, 'Open file-' + title ,'',filetype)
    return fnames

# New file 다이얼 로그
def saveFileDialog(filetype):
    fileName = QFileDialog.getSaveFileName(None,'New file-' + title,'',filetype)[0]
    return fileName


# QGIS install 경로 받아 오기
def GetQGIS_Path():
    try:
        Pathname = QgsApplication.instance().applicationDirPath()+"/.."
        return Pathname

    except Exception as e:
        MsError(e)

def Execute(arg):
    value = call(arg)
    return value

def Get_Folder_Files(path):
    Folder_File_List=[]
    Folder_File_Dict = {}
    Folder_Path=GetFileDirectory_Path(path)
    Folder_File_List=sorted(glob.glob(os.path.join(Folder_Path, '*.out')), key=os.path.getctime)
    for fname in Folder_File_List:
        pass

    pattern = "*.OUT"
    for entry in Folder_File_List:
        if fnmatch.fnmatch(entry, pattern):
           name=os.path.basename(entry).upper().replace(".OUT","")
           #name=GetFile_Name(entry)
           Folder_File_Dict[name]=entry
    return Folder_File_Dict

