# -*- coding: utf-8 -*-

import os
import sys
from qgis.core import *
from qgis.gui import *

from PyQt5 import *
from PyQt5.QtGui import *
from PyQt5.QtWidgets import *

from .lib.Util import *


class RectangleMapTool(QgsMapToolEmitPoint):
    def __init__(self, canvas):
        self.canvas = canvas

    def ZoomtoExtent(self):
        try: 
            MsError("tools in")
            self.canvas.zoomToFullExtent()
            self.canvas.refresh()
        except Exception as e:
            MsError(e)

    def canvas_pan(self):
        try:
            actionPan = QAction(self)
            self.toolPan = QgsMapToolPan(self.canvas)
            self.toolPan.setAction(actionPan)
            self.canvas.setMapTool(self.toolPan)
        except Exception as e:
            MsError(e)



    def Zoomto(self, canvasExtent):
        self.canvas.setExtent(canvasExtent)
        self.canvas.refresh()


