# -*- coding: utf-8 -*-
"""
/***************************************************************************
 CanvasDialog
                                 A QGIS plugin
 Canvas
                             -------------------
        begin                : 2018-12-03
        git sha              : $Format:%H$
        copyright            : (C) 2018 by Canvas
        email                : DHK@hermesys.co.kr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
import sys
import shutil
import glob
import tempfile

from qgis.core import *
from qgis.gui import *

from PyQt5 import *
from PyQt5.QtGui import *
from PyQt5.QtCore import *
from PyQt5.QtWidgets import *
from .Canvas_Tools import RectangleMapTool
from .lib.Util import *
from .lib.File_Class import *
from .Make_PRJ_dialog import *
from xml.etree import ElementTree as ET

from PIL import Image, ImageDraw
import requests

_Default_QML_file=""
_Dem_QML_file=""
_DEM_Path=""
_Pro_File=""
_Simul_Type=""
_th = []

_slide_flag=False


FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'Canvas_dialog_base.ui'))
class CanvasDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None,dempath="",projectfile="",Type="",th=[]):
        super(CanvasDialog, self).__init__(parent)
        self.setupUi(self)

        global _DEM_Path,_Default_QML_file,_Pro_File,_Simul_Type,_th,_Dem_QML_file
        _DEM_Path = dempath
        _Pro_File = projectfile
        _Simul_Type = Type
        _th = th

        self.Dic_Tree_List={}
        self.Temp_Layer_Name=[]
        self.Layer_Name=[]
        #Out 결과 파일 QML 서식
        _Default_QML_file=GetScriptDirectory_Path() + "QML\QGIS_style_depth_ClearNull_all_blue_red.qml"

        #Dem_file 결과 파일 서식
        _Dem_QML_file= GetScriptDirectory_Path() + "QML\QGIS_style_DEM.qml"
        self.SetIni() # 컨트롤러 기본 이벤트 처리

        #self.setWindowFlag(QtCore.Qt.WindowCloseButtonHint, False)
        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.CustomizeWindowHint);

    def SetIni(self):
        try:
            self.layer=None
            
            css = "QGroupBox{padding-top:15px;margin-top:-15px;}"
            self.groupBox_4.setStyleSheet(css)
            self.groupBox_7.setStyleSheet(css)
#             self.groupBox_8.setStyleSheet(css.split(";")[0]+"}")
            
            # 트리 리스트에 파일 목록 셋팅 
            self.Clear_Canvas()
            self.btn_Extent.clicked.connect( self.ZoomtoExtent)
            self.btn_Pan.clicked.connect(self.canvas_pan)
            self.btnSelect_Folder.clicked.connect(lambda : self.Select_Folder(self.txtPng_Folder_Path))
            self.btnDial_gif_path.clicked.connect(lambda : self.Select_make_path(self.txtGif_Path))
            self.btn_QML_Dialog.clicked.connect(lambda : self.Select_QML_path(self.txt_QML_Path))

            # 버튼 아이콘 셋팅
            self.btnUp.setIcon(QIcon(GetScriptDirectory_Path() + "icon\\up.png"))            
            self.btnRemove.setIcon(QIcon(GetScriptDirectory_Path() + "icon\\remove.png"))
            self.btnDown.setIcon(QIcon(GetScriptDirectory_Path() + "icon\\down.png"))
            self.btn_slideStop.setIcon(QIcon(GetScriptDirectory_Path() + "icon\\stop.png"))

            self.btnUp.clicked.connect(self.MoveUp)
            self.btnDown.clicked.connect(self.MoveDown)
            self.btnRemove.clicked.connect(self.ReMove)
            self.btn_Convert_gif.clicked.connect(self.make_gif)

            # 버튼 이벤트 처리 
            self.btn_Get_LayerFile.clicked.connect(self.Get_Layer_Files)
            self.btn_del.clicked.connect(self.Select_tree_del)

            self.btn_QML_Apply.clicked.connect(self.Apply_QML)

            #canvas 때문에
            #self.btn_Canvas_remove.clicked.connect(self.test)
            
            self.btn_maxValuePath.clicked.connect(lambda : self.Save_file(self.txt_maxValuePath))
            self.btn_maxValueRun.clicked.connect(self.runMaxValue)
            
            self.spb_maxValue.setDecimals(5)
            self.spb_maxValue.setMinimum(-99999)
            self.spb_maxValue.setMaximum(99999)
            
            self.btn_pngPath.clicked.connect(lambda : self.Select_Folder(self.txt_pngPath))
            self.btn_convertPng.clicked.connect(self.pngConvertImage)

            self.Layer_List_Tree.setHeaderHidden(True)                          # Tree widget 헤터 숨김 
            self.Layer_List_Tree.itemDoubleClicked.connect(self.itemClicked)    # 클릭 이벤트 처리
            

            #구글 맵 처리 부분 
            self.cmb_base_map.clear()
            self.cmb_base_map.addItems([" select map "," google map ", " DEM "])
            self.cmb_base_map.currentIndexChanged.connect(self.basmap_Changed)

            self.chk_makeImage.stateChanged.connect(self.enableSlide)
            #self.chk_Defaul_QML.stateChanged.connect(self.enable_QML)
            #self.chk_Defaul_QML.setChecked(True)
            #self.enable_QML()

            self.slide_count=0
            self.pause_count=0
            self.slide_control=False

            self.btn_pngPath.setEnabled(False)
            self.btn_convertPng.setEnabled(False)
            self.txt_pngPath.setEnabled(False)
            self.sld_slideBar.setTickPosition(1)    #슬라이드 눈금 표시(0:X, 1:↑, 2:↓, 3:↕)
            self.sld_slideBar.setMaximum(0)
            self.btn_slideStop.clicked.connect(self.slideStopEvent)
            self.btn_slidePause.clicked.connect(self.slidePauseEvent)

            self.sld_slideBar.valueChanged.connect(self.on_changed_value)
            
            self.Layer_List_Tree.setSelectionMode(QAbstractItemView.ExtendedSelection) #2021.09.27 동 : 다중 선택 가능하도록 변경 

            #2019-01-21 박: Canvas 기능 병합 작업(시뮬레이션 결과 표출)
            
#             self.current_timer = None
            self.current_timer = QTimer()
            self.current_timer.timeout.connect(self.Out_file_List_Add_tree)

            if _Simul_Type=="NO":
                self.Set_Tree_Widget()
                self.sld_slideBar.setMaximum(len(self.Dic_Tree_List)-1)
            else :
                self.timer_start_end()

            self.Check_DEM_QML()

            #settings 파일 읽어와서 사용 qml 셋팅
            self.settingsfile_load_setting()

            #base 맵을 DEM 으로 초기에 설정 하기 
            self.cmb_base_map.setCurrentIndex(2)
            self.basmap_Changed()
            self.btn_Close.clicked.connect(self.Close_Form)
        except Exception as e:
            MsError(e)

    def Close_Form(self):
        if len(_th)>0:
            if not _th[0].is_alive():
                self.Clear_Canvas()
                self.close()
            else:
                MsError(" Please end the simulation ")
                return
        else:
            self.Clear_Canvas()
            self.close()
    #2019-10-22 박: 슬라이더 기능 추가 
    def on_changed_value(self,index):
        try:
            #MsError(len(self.Layer_Name))
            #MsError(_slide_flag)
            if len(self.Layer_Name)>0:
                if _slide_flag == False:
                    selectItem = self.Layer_Name[index]  
                    self.Show_Canvas_Layer(index, selectItem)
        except Exception as e:
            MsError(e)

    def settingsfile_load_setting(self):
        _DEM_Default_flag=""
        _DEM_Default_path=""

        _xmlpath=GetScriptDirectory_Path() + "Settings\settings.xml"
        xmlp = ET.XMLParser(encoding="utf-8")
        doc = ET.parse(_xmlpath,parser=xmlp)
        root = doc.getroot()
        global _Dem_QML_file,_Default_QML_file

        for element in root.findall("demqml"):
            _Dem_QML_file=element.findtext("path")

        for element in root.findall("outqml"):
            if element.findtext("path")=="":
                self.txt_QML_Path.setText(_Default_QML_file)
            else:
                self.txt_QML_Path.setText(element.findtext("path"))
 
    #2019-10-16 박: DEM 파일의 QML 서식 파일이 없으면 기본 파일 생성 
    def Check_DEM_QML(self):
        path=os.path.splitext(_DEM_Path)[0]+".qml"
        if not ChFile_Exists(path):
            self.Copy_file(path,"DEM")

    #def test(self):
    #    try:
    #        count=self.Canvas_Main.layerCount()
    #        MsError(count)
    #        #QgsProject.instance().removeMapLayers( self.Layer_list )	
            
    #        QgsProject.instance().removeAllMapLayers()
    #        for layer in self.Canvas_Main.layers():
    #            layer.removeSelection()

    #        self.Canvas_Main.clearCache()

    #    except Exception as e:
    #        MsError(e)

    def Apply_QML(self):
        try: 
            Qml_Path=self.txt_QML_Path.text()
            if ChFile_Exists(Qml_Path):
                global _Default_QML_file
                _Default_QML_file=Qml_Path
                for i in self.Temp_Layer_Name:
                    self.Copy_file(i,"Apply")
                MsInfo(" QML file has been applied. ")
            else:
                MsError(" The path to the QML file you entered is not valid. ")
        except Exception as e:
            MsError(e)


    def Timer_Stop(self):
        self.current_timer.stop()
        # 타이머 종료시에 QML 파일 생성
        #for c in self.Dic_Tree_List.keys():
        #    self.Copy_file(str(self.Dic_Tree_List[c]),"QML")

    def timer_start_end(self):
        try:
            self.btn_Close.setEnabled(False)
            self.btn_Close.setText(" Running simulation ")
            self.btn_slidePause.setEnabled(False)
            self.btn_slideStop.setEnabled(False)
            self.sld_slideBar.setEnabled(False)
            self.current_timer.start(4000)

        except Exception as e:
            MsError(e)

    def Out_file_List_Add_tree(self) :
        try:
            self.Layer_List_Tree.clear()
            self.Dic_Tree_List.clear()
            self.Layer_Name.clear()
            Folder_Files=[]
            Folder_Path=GetFileDirectory_Path(_Pro_File)
            Folder_Files = sorted(glob.glob(os.path.join(Folder_Path, '*.out')), key=os.path.getctime)
            
            for fname in Folder_Files:
                pass
            j =0
            for c in Folder_Files:
                name=os.path.basename(c).upper().replace(".OUT","")
                self.Layer_List_Tree.insertTopLevelItem(j, QTreeWidgetItem([name]))
                self.Dic_Tree_List[name]=c
                self.Layer_Name.append(name)
                #2019-10-11 박:타이머 실행할때 Qml 파일 복사
                  
                self.Copy_file(c,"QML")
                if j==len(Folder_Files)-1 :
                    selectItem = name
                    selectIndex  = j
                    self.Clear_Canvas()
                    self.Show_Canvas_Layer(selectIndex, selectItem)
                j=j+1

            # 2019-10-02 박: 콘솔 실행창 실행되면 쓰레드 체크해서 타이머 자동 종료 
            if not _th[0].is_alive():
                self.current_timer.stop()
                
                self.btn_Close.setText(" Close ")
                self.btn_Close.setEnabled(True)
                self.btn_slidePause.setEnabled(True)
                self.btn_slideStop.setEnabled(True)
                self.sld_slideBar.setEnabled(True)
                self.sld_slideBar.setMaximum(len(self.Dic_Tree_List)-1)

                #for c in self.Dic_Tree_List.keys():
                #    self.Copy_file(str(self.Dic_Tree_List[c]),"QML")
            #else:
            #    MsError("Live")
            

        except Exception as e:
            MsError(e)

    def Set_Tree_Widget(self):
        
        result = {}
        result=Get_Folder_Files(_Pro_File)
        self.Dic_Tree_List=result
        self.Layer_Name=[]

        for i, c in enumerate(list(result)):
            self.Layer_List_Tree.insertTopLevelItem(i, QTreeWidgetItem([c]))

            #QML 파일 생성 확인 
            self.Copy_file(str(self.Dic_Tree_List[c]),"QML")
            #2019-09-23 박: prj 파일을 프로세스가 실행 할때 자동 관리(최박사님 모듈)
            #self.Copy_file(str(self.Dic_Tree_List[c]),"PRJ")
            self.Layer_Name.append(c)


    #treewidget 클릭이벤트 클릭할때 마다 Canvas 표출 레이어 변경됨 
    def itemClicked(self, item):
        try:
            selectItem = item.text(0)
            selectIndex  = self.Layer_List_Tree.currentIndex().row()
            self.Show_Canvas_Layer(selectIndex, selectItem)
        except Exception as e:
            MsError(e)

 #캔버스에 레이어 보여주기
    def Show_Canvas_Layer(self, index, subject):
        try:
            self.lbl_layername.setText(subject)
            if self.cmb_base_map.currentIndex()==0:
                self.Clear_Canvas()
                self.layer =None
                self.layer=QgsRasterLayer(self.Dic_Tree_List[subject], subject, "gdal")
                self.Canvas_Main.setDestinationCrs(self.layer.crs())
                QgsProject.instance().addMapLayer(self.layer, False)
    
                self.Canvas_Main.setLayers([self.layer])
                self.Canvas_Main.setExtent(self.layer.extent())

            elif self.cmb_base_map.currentIndex()==1:
                self.Clear_Canvas()
                self.layer =None
                self.layer=QgsRasterLayer(self.Dic_Tree_List[subject], subject, "gdal")
                self.Canvas_Main.setDestinationCrs(self.layer.crs())
                service_uri = "type=xyz&url=https://mt1.google.com/vt/lyrs%3Dy%26x%3D%7Bx%7D%26y%3D%7By%7D%26z%3D%7Bz%7D&zmax=18&zmin=0"
                tms_layer = QgsRasterLayer(service_uri, "google hybrid", "wms")
                QgsProject.instance().addMapLayer(tms_layer, False)

                self.Canvas_Main.setLayers([self.layer]+[tms_layer])
                self.Canvas_Main.setExtent(self.layer.extent())

            elif self.cmb_base_map.currentIndex()==2:
                self.Clear_Canvas()
                self.base_map=None
                self.layer =None
                self.layer=QgsRasterLayer(self.Dic_Tree_List[subject], subject, "gdal")
                self.Canvas_Main.setDestinationCrs(self.layer.crs())
                Name =GetFile_Name(_DEM_Path)
                self.base_map=QgsRasterLayer(_DEM_Path, Name, "gdal")

                self.Canvas_Main.setLayers([self.layer]+[self.base_map])
                self.Canvas_Main.setExtent(self.layer.extent())
        except Exception as e:
            MsError(e)


    def Get_Layer_Files(self):
        self.Files=QFileDialog.getOpenFileNames(self, "Open Tif Files",'',"OUT (*.out)",options=QFileDialog.DontUseNativeDialog)[0]
        for i, c in enumerate(self.Files):
            file_name = GetFile_Name(os.path.basename(self.Files[i]))
            self.Layer_List_Tree.insertTopLevelItem(i, QTreeWidgetItem([file_name]))
            self.Dic_Tree_List[file_name]=self.Files[i]

    def Select_tree_del(self):
        try:
            root = self.Layer_List_Tree.invisibleRootItem()
            for item in self.Layer_List_Tree.selectedItems():
                del self.Dic_Tree_List[item.text(0)]
                (item.parent() or root).removeChild(item)
            #self.slid_bar_Maxset()
        except Exception as e:
            MsError(e)
 
    def Select_Folder(self,txt):
        try:
            folderpath=QFileDialog.getExistingDirectory(self, 'Select directory')
            if CheckFolder(folderpath):
                txt.setText(folderpath)
                self.SetFileList(folderpath)
        except Exception as e:
            MsError(e)
    
    def Save_file(self,txt):
        try:
            filePath=QFileDialog.getSaveFileName(self, 'Save file name', "", "ASCII Grid (*.asc)")[0]
            if CheckFolder(GetFileDirectory_Path(filePath)):
                txt.setText(filePath)
                
        except Exception as e:
            MsError(e)

    #2019-12-11: park
    # error file list 
    def SetFileList(self,path):
        try:
            self.tblPng_List.setColumnCount(1)
            self.tblPng_List.setHorizontalHeaderLabels(['Image List'])
            file_list = os.listdir(path)
            filelist = [file for file in file_list if file.endswith(".png")]

            filelist.sort(key=lambda f: int("".join(list(filter(str.isdigit, f)))))
            for fname in filelist:
                pass
            i =0
            for fichier in filelist:
                if fichier.endswith(".png"):
                    self.tblPng_List.insertRow(i)
                    self.tblPng_List.setItem(i, 0, QTableWidgetItem(fichier))
                    i = i + 1
        except Exception as e:
            MsError(e) 

    def MoveUp(self):
        row = self.tblPng_List.currentRow()
        column = self.tblPng_List.currentColumn()
        if row > 0:
            self.tblPng_List.insertRow(row - 1)
            for i in range(self.tblPng_List.columnCount()):
                self.tblPng_List.setItem(row - 1, i, self.tblPng_List.takeItem(row + 1, i))
                self.tblPng_List.setCurrentCell(row - 1, column)
            self.tblPng_List.removeRow(row + 1)


    def MoveDown(self):
        row = self.tblPng_List.currentRow()
        column = self.tblPng_List.currentColumn()
        if row>=0:
            if row < self.tblPng_List.rowCount() - 1:
                self.tblPng_List.insertRow(row + 2)
                for i in range(self.tblPng_List.columnCount()):
                    self.tblPng_List.setItem(row + 2, i, self.tblPng_List.takeItem(row, i))
                    self.tblPng_List.setCurrentCell(row + 2, column)
                self.tblPng_List.removeRow(row)


    def ReMove(self):
        row = self.tblPng_List.currentIndex().row()
        mess="Are you sure you want to delete the selected items?"
        result=QMessageBox.question(None, "G2D",mess,QMessageBox.Yes, QMessageBox.No)
        if result == QMessageBox.Yes:
            self.tblPng_List.removeRow(row)

    def make_gif(self):
        try:
            img_list = []
            if self.tblPng_List.rowCount()>0:
                for i in range(self.tblPng_List.rowCount()):
                    frame = Image.open(self.txtPng_Folder_Path.text()+"/" + self.tblPng_List.item(i,0).text())
                    img_list.append(frame)

                duration_time=self.Interval_box.value()*1000
                img_list[0].save(self.txtGif_Path.text(), format='GIF', append_images=img_list[1:], save_all=True, duration=duration_time, loop=0)
                MsInfo("Make GIF")
            else:
                MsError("No PNG file selected.")

        except Exception as ex:
            MsError(ex) 


    def Select_make_path(self,txt):
        filename = QFileDialog.getSaveFileName(self, "select output file ", "", "*.gif")[0]
        if len(filename)>0:
            txt.setText(filename)

    def Select_QML_path(self,txt):
        filename = QFileDialog.getOpenFileNames(self, "Open QML Files",'',"QML (*.QML)",options=QFileDialog.DontUseNativeDialog)[0]
        if len(filename)>0:
            txt.setText(filename[0])

    def ZoomtoExtent(self):
        try: 
            self.Canvas_Main.zoomToFullExtent()
            self.Canvas_Main.refresh()
        except Exception as e:
            MsError(e)

    def canvas_pan(self):
        try:
            actionPan = QAction(self)
            self.toolPan = QgsMapToolPan(self.Canvas_Main)
            self.toolPan.setAction(actionPan)
            self.Canvas_Main.setMapTool(self.toolPan)
        except Exception as e:
            MsError(e)

    def Copy_file(self,path,type):
        try:
            if type=="QML":
                if path not in self.Temp_Layer_Name:
                    QML_Path = path.upper().replace("OUT","QML")
                    shutil.copy2(_Default_QML_file,QML_Path )
                    self.Temp_Layer_Name.append(path)
            elif type=="DEM":
                QML_Path = path.upper().replace("ASC","QML")
                shutil.copy2(_Dem_QML_file,QML_Path )
            elif type=="Apply":
                QML_Path = path.upper().replace("OUT","QML")
                shutil.copy2(_Default_QML_file,QML_Path )
            else: 
                QML_Path = path.upper().replace("OUT","PRJ")
                shutil.copy2(_Prj_File,QML_Path )
        except Exception as e:
            MsError(e)

    def enableSlide(self):
        enableList=[self.btn_pngPath, self.btn_convertPng, self.txt_pngPath,self.btn_slidePause, self.btn_slideStop, self.sld_slideBar]
        for el in enableList:
            el.setEnabled(not el.isEnabled())
    
    def changePngBtnText(self, flag):
        txt = " Stop " if flag else "Convert png"
        self.btn_convertPng.setText(txt) 
    
    def pngConvertImage(self):
        Make_Folder=self.txt_pngPath.text()
        if not CheckFolder(Make_Folder):
            MsInfo(" Please check the folder path ")
            return

        #2019/11/21 박:최박사님 요청으로 변경 이미지 변환 중지 기능
        if self.btn_convertPng.text()=='Convert png':
            self.changePngBtnText(True)
            global _slide_flag
            _slide_flag = True
            self.slide_count=0
            self.slideImage()
            _slide_flag = False
        else:
            self.slideStopEvent()
            self.changePngBtnText(False)


    #슬라이드 작동
    def slideImage(self):
        try:
            #빠르게 pause를 눌렀을 때 두번 실행 되는 것을 막기 위함.
            self.slide_control=not self.slide_control 

            #2019-02-20 박: 딕션너리 변경으로 인덱스가 아닌 이름으로 검색 
            item = self.Layer_List_Tree.topLevelItem(self.slide_count)
            if not item:
                self.changePngBtnText(False)
                raise Warning("Please run the simulation first.")
            self.Show_Canvas_Layer(0, item.text(0))
            
            if self.slide_control:
                QTimer.singleShot(1000, self.exportMap)
            if self.slide_count==len(self.Dic_Tree_List)-1:
                self.slideStopEvent()
        except Exception as e:
            MsError(e)


    #슬라이드의 실질적인 작동 내용
    def exportMap(self):
        try:
            self.slide_control=False
            checkFlag = self.chk_makeImage.isChecked()
            savePath = self.txt_pngPath.text()
            
            qApp.processEvents() #보류중인 이벤트 처리 : 캔버스에 그림이 뜨지 않을 경우를 
            if checkFlag:
                if self.btn_slidePause.text()!=u'\u25B6':
                    self.btn_slidePause.setText(u'\u25B6')
                    return
            
                #_error.savePathError(savePath)
                self.Canvas_Main.saveAsImage(savePath+"/"+self.Layer_Name[self.slide_count]+".png")

            #2019-02-20 박: 딕셔너리 변경 
            if self.slide_count<len(self.Dic_Tree_List)-1:
            #if self.slide_count<len(self.Files_List)-1:
                #self.slide_count+=1
                #MsError("slide_count :" + str(self.slide_count))
                self.slide_count+=1
                self.pause_count=self.slide_count
                self.sld_slideBar.setSliderPosition(self.slide_count)
                QTimer.singleShot(500, self.slideImage)
            else:
                if checkFlag:
                    self.pause_count=0
                    self.SetFileList(savePath)
                    self.txtPng_Folder_Path.setText(savePath)
                    self.changePngBtnText(False)
                    MsInfo("Convert to png image complete.")
                self.btn_slidePause.setText(u'\u25B6')
        
        except Exception as e:
            MsError(e)
 
    def slideStopEvent(self):
        global _slide_flag
        self.btn_slidePause.setText(u'\u25B6')
        self.pause_count=0
        self.slide_count=len(self.Dic_Tree_List)-1
        self.sld_slideBar.setSliderPosition(0)
        _slide_flag = False
        item = self.Layer_List_Tree.topLevelItem(0)
        if item:
            self.lbl_layername.setText(item.text(0))


    def slidePauseEvent(self):
        try:
            global _slide_flag
            # 플레이 버튼이 실행 버튼일때 

            if self.btn_slidePause.text()==u'\u25B6':
                if len(self.Dic_Tree_List)==0:
                    return
                #2019-10-22 박: 마우스 슬라이드 기능 처리

                _slide_flag = True
                self.btn_slidePause.setText(chr(124)+chr(124))
                self.slide_count=self.pause_count
                self.slideImage()
            else:
                # 플레이 버튼이 중지 중일때
                _slide_flag = False
                self.btn_slidePause.setText(u'\u25B6')
                self.slide_count=len(self.Dic_Tree_List)-1

        except Exception as e:
            MsError(e)

    def Clear_Canvas(self):
        try:
            #레이어가 자꾸 잡혀 있어서 프로세스가 사용중으로 나옴 그래서 레이어 삭제 기능 추가해서 넣음
            self.layer =None
            layers = self.Canvas_Main.layers()
            for l in layers:
                QgsProject.instance().removeMapLayer(l.id())
#             QgsProject.instance().removeAllMapLayers()
            self.Canvas_Main.clearCache()
        except Exception as e:
            pass

    #def Setting_out_file(self):
    #    try:
    #        self.Layer_Name=QStringList()
    #        for file in os.listdir(os.path.dirname(Project._Project_File_Path)):
    #            if file.endswith(".out"): #끝이 ".txt"로 끝나는 경우
    #                name = _util.GetFilename(file)

    #                self.Dic_Tree_List[name]=str(os.path.dirname(Project._Project_File_Path) + "/" + file)
    #                #self.Files_List.append(str(os.path.dirname(Project._Project_File_Path) + "/" + file))

    #                # OUT 파일에 좌표 정보가 없어서 구글 좌표계 PRJ 파일을 복사해서 넣는 방식 
    #                self.Copy_Prj_File(str(os.path.dirname(Project._Project_File_Path) + "/" + file))

    #                self.Layer_Name.append(name)
    #        for i, c in enumerate(self.Layer_Name):
    #            self.Layer_List_Tree.insertTopLevelItem(i, QTreeWidgetItem([c]))
    #        self.sld_slideBar.setMaximum(len(self.Dic_Tree_List)-1)
    #    except Exception as e:
    #        MsError(e)

    def basmap_Changed(self):
        try:
            if self.cmb_base_map.currentIndex()==1:
                if self.layer is None:
                    service_uri = "type=xyz&url=https://mt1.google.com/vt/lyrs%3Dy%26x%3D%7Bx%7D%26y%3D%7By%7D%26z%3D%7Bz%7D&zmax=18&zmin=0"
                    tms_layer = QgsRasterLayer(service_uri, "google hybrid", "wms")
                    QgsProject.instance().addMapLayer(tms_layer, False)
                    self.Canvas_Main.setLayers([tms_layer])
                    self.Canvas_Main.setExtent(tms_layer.extent())
                    self.Canvas_Main.refresh()
                else:
                    service_uri = "type=xyz&url=https://mt1.google.com/vt/lyrs%3Dy%26x%3D%7Bx%7D%26y%3D%7By%7D%26z%3D%7Bz%7D&zmax=18&zmin=0"
                    tms_layer = QgsRasterLayer(service_uri, "google hybrid", "wms")
                    QgsProject.instance().addMapLayer(tms_layer, False)
                    self.Canvas_Main.setLayers([self.layer]+[tms_layer])
                    self.Canvas_Main.setExtent(self.layer.extent())
            elif self.cmb_base_map.currentIndex()==2:
                self.base_map=None
                if self.layer is None:
                    Name =GetFile_Name(_DEM_Path)
                    self.base_map=QgsRasterLayer(_DEM_Path, Name, "gdal")
                    self.Canvas_Main.setLayers([self.base_map])
                    self.Canvas_Main.setExtent(self.base_map.extent())
                    self.Canvas_Main.refresh()
                else:
                    Name =GetFile_Name(_DEM_Path)
                    self.base_map=QgsRasterLayer(_DEM_Path, Name, "gdal")
                    self.Canvas_Main.setLayers([self.layer]+[self.base_map])
                    self.Canvas_Main.setExtent(self.layer.extent())
                    self.Canvas_Main.refresh()
            else:
                self.base_map=None
        except Exception as e:
            MsError(e) 
            
    def runMaxValue(self):
        try:
            rstPath = self.txt_maxValuePath.text()
            exePath = os.path.join(os.path.dirname(__file__), "G2D/Max_Value_ASC_Create.exe")
            items = self.Layer_List_Tree.selectedItems()
            limit = self.spb_maxValue.value()
            
            if not CheckFolder(GetFileDirectory_Path(rstPath)):
                raise Warning("Please check the save file path")
            if len(items)==0:
                raise Warning("Please select the layers")
            
            with tempfile.TemporaryDirectory() as tmpdir:
                for item in items:
                    fileName = item.text(0)
                    filePath = self.Dic_Tree_List[fileName]
                    shutil.copy2(filePath, os.path.join(tmpdir, fileName+".out"))
                    
                arg = f'"{exePath}" "{tmpdir}" {limit} "{rstPath}"'
                Execute(arg) #util.py 함수
            
            MsInfo("Completed the max value operation.")
        except Exception as e:
            MsError(e)