﻿# -*- coding: utf-8 -*-
"""
/***************************************************************************
 G2DDialog
                                 A QGIS plugin
  
 Generated by Plugin Builder: http://g-sherman.github.io/Qgis-Plugin-Builder/
                             -------------------
        begin                : 2019-05-13
        git sha              : $Format:%H$
        copyright            : (C) 2019 by KICT, Hermesys
        email                : shpark@hermesys.co.kr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
"""
import os
from PyQt5 import uic
from PyQt5 import QtWidgets
from PyQt5.QtWidgets import QDockWidget
from .lib.Util import *
from .lib.File_Class import *
from xml.etree.ElementTree import *
import xml.etree.ElementTree as ET

_DEM_Default_flag=""
_DEM_Default_path=""

_OUT_Default_flag=""
_OUT_Default_path=""
_Default_QML_file=""
_Dem_QML_file= ""
_xmlpath=""


FORM_CLASS, _ = uic.loadUiType(os.path.join(os.path.dirname(__file__), 'Settings_dialog_base.ui'))
class SettingsDialog(QtWidgets.QDialog, FORM_CLASS):
    def __init__(self, parent=None):
        super(SettingsDialog, self).__init__(parent)
        self.setupUi(self)
        self.setini()

    def setini(self):
        #settings xml 파일 경로 확인 

        global _Default_QML_file,_Dem_QML_file,_xmlpath
        _Default_QML_file=GetScriptDirectory_Path() + "QML\QGIS_depth_style_ClearNull_all_red_blue.qml"
        _Dem_QML_file= GetScriptDirectory_Path() + "QML\QGIS_style_DEM.qml"

        _xmlpath=GetScriptDirectory_Path() + "Settings\settings.xml"
        if ChFile_Exists(_xmlpath):
            self.Openxml()
        else:
            self.MakeXml()
            self.Openxml()

        self.btn_DEM_QML_dial.clicked.connect(lambda:self.Qml_dialog(self.txt_DEM_QML) )
        self.btn_OUT_QML_dial.clicked.connect(lambda:self.Qml_dialog(self.txt_OUT_QML) )
        self.btn_ok.clicked.connect(self.click_ok)
        self.btn_cancel.clicked.connect(self.Close_Form)

    def click_ok(self):
        dem_qml=self.txt_DEM_QML.text()
        if not ChFile_Exists(dem_qml):
            MsInfo(" Please check the QML file ")
            return

        out_qml=self.txt_OUT_QML.text()
        if not ChFile_Exists(out_qml):
            MsInfo(" Please check the QML file ")
            return
        
        doc = ET.parse(_xmlpath)
        root = doc.getroot()

        for element in root.findall("demqml"):
            element.find("path").text = self.txt_DEM_QML.text()

        for element in root.findall("outqml"):
            element.find("path").text = self.txt_DEM_QML.text()
        doc.write(_xmlpath)
        MsInfo(" The save is complete. ")
        self.Close_Form()
    def Qml_dialog(self,txt):
        result=OpenFileDialog("*.QML")
        txt.setText(str(result))

    def Openxml(self):
        global _DEM_Default_flag,_DEM_Default_path,_OUT_Default_flag,_OUT_Default_path
        xmlp = ET.XMLParser(encoding="utf-8")
        doc = ET.parse(_xmlpath,parser=xmlp)
        root = doc.getroot()

        for element in root.findall("demqml"):
            _DEM_Default_path=element.findtext("path")

        for element in root.findall("outqml"):
            _OUT_Default_path=element.findtext("path")

        self.Setting_control()


    def Close_Form(self):
        self.close()

    def Setting_control(self):
        if _DEM_Default_path=="":
            self.txt_DEM_QML.setText(_Dem_QML_file)
        else:
            self.txt_DEM_QML.setText(_DEM_Default_path)

        if _OUT_Default_path=="":
            self.txt_OUT_QML.setText(_Default_QML_file)
        else:
            self.txt_OUT_QML.setText(_OUT_Default_path)

    def MakeXml(self):
        xmlStr = '''<?xml version="1.0" encoding="utf-8"?>
        <Settings>
            <demqml>
                <path>''' +  _Default_QML_file + '''</path>
            </demqml>
            <outqml>
                <path>''' + _Default_QML_file + '''</path>
            </outqml>
        </Settings>
        '''
        myfile = open(_xmlpath, "w")
        myfile.write(xmlStr)

