# -*- coding: utf-8 -*-
import os
import sys
import enum
from .File_Class import *
from .Util import *

# 2019-04-05 박: 프로그램 개발에 앞서 내부 모듈에서 사용하는 함수 정리해두기 

# ASC 파일 구조
# ---------------------
# ncols     0     
# nrows     1    
# xllcorner 2   
# yllcorner 3   
# cellsize  4   
# NODATA_value 5......증가 (갯수구하기 len(HeaderDict)-5)
# ---------------------

# ASC File header 값받아 오기 
def GetASC_Header(asc):
    try:
        # header 값 반환 DIC
        HeaderDict={}
        HaederBody_List=[]

        # asc 파일 전체 읽기
        ASC_file = open(asc, 'r')
        lines = ASC_file.readlines()
        line_count = 0 

        # 딕셔너리 호출시 
        # ex) HeaderDict[ASC_Header.NCOLS]  or HeaderDict[0] 호출 방법
        for line in lines:
            if line_count==0:
                HeaderDict[0] = Header_Value(line)
            elif line_count==1:
                HeaderDict[1] = Header_Value(line)
            elif line_count==2:
                HeaderDict[2] = Header_Value(line)
            elif line_count==3:
                HeaderDict[3] = Header_Value(line)
            elif line_count==4:
                HeaderDict[4] = Header_Value(line)
            elif line_count==5:
                HeaderDict["BODY"+str(line_count)] = Header_Value(line)
            else:
                HeaderDict[line_count]= line
            line_count = line_count + 1
        ASC_file.close()

        # 반환은 딕셔너리로 반환합 
        # 0~~5번 까지는 헤더값, 6부터 끝까지는 바디값 
        return HeaderDict
    except Exception as e:
        ASC_file.close()
        MsInfo(e)

# header의 라인을 읽어서 값을 반환 하는 함수 
def Header_Value(line):
    result = line.upper().replace("NCOLS","").replace("NROWS","").replace("XLLCONER","").replace("YLLCONER","").replace("CELLSIZE","").replace("NODATA_VALUE","").strip()
    return result

# ASC Prj 정보정보 가져 오기 (EPSG 받아오는거 해봐야 함)
def GetPrj_Info(asc):
    if ChFile_Exists(asc):
        readPRJ= GetRead_Txt(asc)
        return readPRJ
    else: 
        return ""



