# -*- coding: utf-8 -*-
import os
import fnmatch
import sys

from qgis.core import *
from PyQt5.QtWidgets import *
from PyQt5.QtCore import *
from winreg import *
from .File_Class import *
from subprocess import call
from subprocess import Popen
import glob
import xml.etree.ElementTree as ET


# 메시지 박스 타이틀 일괄 적용 하기
# 미리 한번 호출해서 값 셋팅
def MsTitle(name):
    global title
    title = name

def MsInfo(mess):
    QMessageBox.information(None, title, str(mess)) 

def MsError(mess):
    QMessageBox.warning(None,title, str(mess))

# 파일 다이얼 로그는 각자 만들어 쓰는게 편할지도... 임시로 만들어 둠    
def OpenFileDialog(txtbox,filetype):
    fname = QFileDialog.getOpenFileName(None, 'Open file-' + title ,'',filetype)
    txtbox.setText(str(fname[0]))

# 파일 다이얼 로그는 각자 만들어 쓰는게 편할지도... 임시로 만들어 둠    
def OpenFileDialog(filetype):
    fname = QFileDialog.getOpenFileName(None, 'Open file-' + title ,'',filetype)
    return str(fname[0])

# 파일 다이얼 로그는 각자 만들어 쓰는게 편할지도... 임시로 만들어 둠    
def OpenFilesDialog(filetype):
    fnames = QFileDialog.getOpenFileNames(None, 'Open file-' + title ,'',filetype)
    return fnames

# New file 다이얼 로그
def saveFileDialog(filetype):
    fileName = QFileDialog.getSaveFileName(None,'New file-' + title,'',filetype)[0]
    return fileName


# 레지스트리에서 QGIS 3.6 install 경로 받아 오기
def GetQGIS_Path():
    try:
        Pathname = QgsApplication.instance().applicationDirPath()+"/.."
        return Pathname

    except Exception as e:
        MsError(e)

def Execute(arg):
    value = call(arg)
    return value

def Get_Folder_Files(path):
    Folder_File_List=[]
    Folder_File_Dict = {}
    Folder_Path=GetFileDirectory_Path(path)
    Folder_File_List=sorted(glob.glob(os.path.join(Folder_Path, '*.out')), key=os.path.getctime)
    for fname in Folder_File_List:
        pass

    pattern = "*.OUT"
    for entry in Folder_File_List:
        if fnmatch.fnmatch(entry, pattern):
           name=os.path.basename(entry).upper().replace(".OUT","")
           Folder_File_Dict[name]=entry
    return Folder_File_Dict


#2020-01-09 콤보박스 레이어 셋팅 하기(...)
# 콤보박스 리스트 셋팅 type은( tif, shp , "" 일땐 모두다)
def SetCommbox(layers, commbox, type):
    layer_list = []
    if type.upper() == "TIF" or  type.upper() == "ASC" :
        for layer in layers:
            layertype = layer.type()
            if layertype == layer.RasterLayer:
                layer_list.append(layer.name())
    elif type.upper() == "SHP":
        for layer in layers:
            layertype = layer.type()
            if layertype == layer.VectorLayer:
                layer_list.append(layer.name())
    else:
        for layer in layers:
            layer_list.append(layer.name())
    commbox.clear()
    combolist = ['select layer']
    combolist.extend(layer_list)
    commbox.addItems(combolist)

# 콤보 박스에 있는 목록중에 프로젝트 상에 있는 레이어 비교 하여 있으면 콤보박스에 선택
def SetCommbox2(commboxs,layername,filepath):
    try:
        index = commboxs.findText(str(layername))
        if GetTxtToLayerPath(layername) == filepath :
            if index >= 0:
                commboxs.setCurrentIndex(index)
    except Exception as e:
        MsError(e)

# 레이어 명으로 경로 받아 오기
def GetTxtToLayerPath(layernametxt):
    try: 
        layername = layernametxt
        layer = None
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
        if layer != None :
            return layer.dataProvider().dataSourceUri()
        else :
            return "Null"
    except Exception as e:
        MsError(e)

 # 콤보 박스에서 선택된 레이어 경로 받아 오기
def GetcomboSelectedLayerPath( commbox):
    layername = commbox.currentText()
    if layername == 'select layer':
        return ""
    else:
        layer = None
        for lyr in QgsProject.instance().mapLayers().values():
            if lyr.name() == layername:
                layer = lyr
        return layer.dataProvider().dataSourceUri()

def FlowControlGrid_XmlCount(ProjectFile):
    FlowNameCount = []
    doc = ET.parse(ProjectFile)
    root = doc.getroot()
    for element in root.findall('{http://tempuri.org/GRMProject.xsd}FlowControlGrid'):
        FlowNameCount.append(element.findtext("{http://tempuri.org/GRMProject.xsd}Name"))
    return len(FlowNameCount)


def Opewn_ViewFile(path):
    _notpad = "C:/Windows/System32/notepad.exe"
    Popen([_notpad,path])