# -*- coding: utf-8 -*-

import os
import sys
import xml.etree.ElementTree as ET
from .lib.File_Class import *
from .lib.Util import indent

class make:
    def __init__(self):
       self.ProjectFile = ""

    # New Project 시에 GMP 파일 생성 하기
    def Make_GMP_File(self,save_gmp_path):
        GRMProject = ET.Element("GRMProject")
        GRMProject.set("xmlns", "http://tempuri.org/GRMProject.xsd")
        ProjectSettings = ET.SubElement(GRMProject, "ProjectSettings")
        ET.SubElement(ProjectSettings, 'ProjectFile').text = save_gmp_path
        ET.SubElement(ProjectSettings, 'GRMSimulationType').text = 'SingleEvent'
        ET.SubElement(ProjectSettings, 'DomainFile')
        ET.SubElement(ProjectSettings, 'SlopeFile')
        ET.SubElement(ProjectSettings, 'FlowDirectionFile')
        ET.SubElement(ProjectSettings, 'FlowAccumFile')
        ET.SubElement(ProjectSettings, 'StreamFile')
        ET.SubElement(ProjectSettings, 'ChannelWidthFile')
        ET.SubElement(ProjectSettings, 'InitialSoilSaturationRatioFile')
        ET.SubElement(ProjectSettings, 'LandCoverDataType').text = 'File'
        ET.SubElement(ProjectSettings, 'LandCoverFile')
        ET.SubElement(ProjectSettings, 'LandCoverVATFile')
        ET.SubElement(ProjectSettings, 'ConstantRoughnessCoeff')
        ET.SubElement(ProjectSettings, 'ConstantImperviousRatio')
        ET.SubElement(ProjectSettings, 'SoilTextureDataType').text = 'File'
        ET.SubElement(ProjectSettings, 'SoilTextureFile')
        ET.SubElement(ProjectSettings, 'SoilTextureVATFile')
        ET.SubElement(ProjectSettings, 'ConstantSoilPorosity')
        ET.SubElement(ProjectSettings, 'ConstantSoilEffPorosity')
        ET.SubElement(ProjectSettings, 'ConstantSoilWettingFrontSuctionHead')
        ET.SubElement(ProjectSettings, 'ConstantSoilHydraulicConductivity')
        ET.SubElement(ProjectSettings, 'SoilDepthDataType').text = 'File'
        ET.SubElement(ProjectSettings, 'SoilDepthFile')
        ET.SubElement(ProjectSettings, 'SoilDepthVATFile')
        ET.SubElement(ProjectSettings, 'ConstantSoilDepth')
        ET.SubElement(ProjectSettings, 'InitialChannelFlowFile')
        ET.SubElement(ProjectSettings, 'RainfallDataType').text = 'TextFileASCgrid'
        ET.SubElement(ProjectSettings, 'RainfallInterval')
        ET.SubElement(ProjectSettings, 'RainfallDataFile')
        ET.SubElement(ProjectSettings, 'FlowDirectionType').text = 'StartsFromE_TauDEM'
        ET.SubElement(ProjectSettings, 'MaxDegreeOfParallelism').text = '-1'
        ET.SubElement(ProjectSettings, 'SimulStartingTime').text = '0'
        ET.SubElement(ProjectSettings, 'ComputationalTimeStep')
        ET.SubElement(ProjectSettings, 'IsFixedTimeStep').text = 'false'
        ET.SubElement(ProjectSettings, 'SimulationDuration')
        ET.SubElement(ProjectSettings, 'OutputTimeStep')
        ET.SubElement(ProjectSettings, 'SimulateInfiltration').text = 'true'
        ET.SubElement(ProjectSettings, 'SimulateSubsurfaceFlow').text = 'true'
        ET.SubElement(ProjectSettings, 'SimulateBaseFlow').text = 'true'
        ET.SubElement(ProjectSettings, 'SimulateFlowControl').text = 'false'
        ET.SubElement(ProjectSettings, 'MakeIMGFile').text = 'false'
        ET.SubElement(ProjectSettings, 'MakeASCFile').text = 'false'
        ET.SubElement(ProjectSettings, 'MakeSoilSaturationDistFile').text = 'true'
        ET.SubElement(ProjectSettings, 'MakeRfDistFile').text = 'true'
        ET.SubElement(ProjectSettings, 'MakeRFaccDistFile').text = 'true'
        ET.SubElement(ProjectSettings, 'MakeFlowDistFile').text = 'true'
        ET.SubElement(ProjectSettings, 'PrintOption').text = 'All'
        ET.SubElement(ProjectSettings, 'WriteLog').text = 'false'
        ET.SubElement(ProjectSettings, 'AboutThisProject')
        ET.SubElement(ProjectSettings, 'AboutWatershed')
        ET.SubElement(ProjectSettings, 'AboutLandCoverMap')
        ET.SubElement(ProjectSettings, 'AboutSoilMap')
        ET.SubElement(ProjectSettings, 'AboutSoilDepthMap')
        ET.SubElement(ProjectSettings, 'AboutRainfall')
        ET.SubElement(ProjectSettings, 'ProjectSavedTime')

        # PC 이름 가져오기
        pc_name = os.getenv("COMPUTERNAME")

        # USER (로그인 된 계정) 이름 가져오기
        user_name = os.getenv("USERNAME")

        ET.SubElement(ProjectSettings, 'ComputerName').text = pc_name
        ET.SubElement(ProjectSettings, 'ComputerUserName').text = user_name
        ET.SubElement(ProjectSettings, 'GRMVersion').text = ""
        indent(GRMProject)
        ET.ElementTree(GRMProject).write(save_gmp_path, encoding="utf-8", xml_declaration=True)
#         self.indent(save_gmp_path)
# 
#     def indent(self,Pro_path):
#         arg=GetScriptDirectory_Path()+ "/ReWriteXML/ReadAndWriteXML.exe " + Pro_path
#         callExecute(arg)
