"""
2021.11.30 동
- 정규식으로 값 검증을 위한 함수들.

^ 행의 시작을 알림
$ 행의 끝을 알림

result 반환 
    - true : bool
    - false : 문자열
"""

import re

def verifiDecorator(func):
    def decorated(*args, **kwargs):
        exp, value, rstKind = func(*args, **kwargs)
        
        comp = re.compile(exp)
        rst = comp.match(value)
        if rstKind:
            return bool(rst and rst.group())
        else:
            return rst.group() if rst else None 
    return decorated


@verifiDecorator
def intVerification(value, rstKind=True): 
    exp = r"^[\d,]+$"
    return [exp, value, rstKind]

@verifiDecorator
def floatVerification(value, rstKind=True):
    exp = r"^[,\d]*(\.?\d*)$"
    return [exp, value, rstKind]

@verifiDecorator
def retrPdDayVerification(value, rstKind=True):
    exp = r"^\d{2}[mM]\d{2}[dD]$"
    return [exp, value, rstKind]
