import re


def camel_to_snake_case(input_string):
    # Use a regular expression to split the input string at each capital letter
    words = re.findall(r"[A-Z][a-z\_]*", input_string)

    # Use the lower() method to convert all words to lowercase
    words = [word.lower() for word in words]

    # Use the join() method to join the words with underscores
    result = "_".join(words)

    return result


if __name__ == "__main__":
    print(camel_to_snake_case("CamelCase"))
    print(camel_to_snake_case("CamelCamelCase"))
    print(camel_to_snake_case("Camel2Camel2Case_case"))
    print(camel_to_snake_case("getHTTPResponseCode"))
    print(camel_to_snake_case("get2HTTPResponseCode"))
    print(camel_to_snake_case("HTTPResponseCode"))
    print(camel_to_snake_case("HTTPResponseCodeXYZ"))
