﻿# -*- coding: utf-8 -*-
"""
***************************************************************************
2020-01-09
Land_Cover 데이터 처리 부분 함수에 모아서 한번에 관리 하기 위해서 작성 
영문 GRMTextureE,GRMTextureK.... 삭제 부분은 기존 Project 파일에서 삭제

GreenAmpt 배열값 순서(7)	SoilDepth 배열값 순서(3)	    LandCover 배열값 순서(5)
1.GridValue 	            1.GridValue	                    1.GridValue
2.USERSoil	                2.UserDepthClass	            2.UserLandCover
3.GRMCode	                3.GRMCode	                    3.GRMCode
4.GRMTextureE  --삭제	    4.SoilDepthClassE --삭제	    4.GRMLandCoverE --삭제
5.GRMTextureK  --삭제	    5.SoilDepthClassK --삭제 	    5.GRMLandCoverK --삭제
6.Porosity		                                            6.RoughnessCoefficient
7.EffectivePorosity		                                    7.ImperviousRatio
8.WFSoilSuctionHead		
9.HydraulicConductivity		

***************************************************************************
"""
import os
from ..lib.Util import *

class LandCover():
    def __init__(self):

         #GreenAmpt 배열값 개수 
         self.GAmpt_Count=0

         #Soil 배열값 개수
         self.SoilDepth_Count=0

         #LandCover 배열값 개수
         self.LandCoverCount=0

    '''
    배열 생성하면서 임시 값을 넣음(0) 값이 7개임 9개에서 2개바 빠짐
    xml 체크 하면서 갯수 파악해서 변수 생성함 
    만약에 해당하는 요소가 없으면 2차원 배열 [1][1] 로 생성 함 객체
    '''
    def Create_GAmpt_Array(self,count):
        try:
            if count>0:
                
                self.GAmpt_Array=[[0 for col in range(7)] for row in range(count)]
                self.GAmpt_Count=count
            else:
                self.GAmpt_Array=[[0 for col in range(1)] for row in range(1)]
                self.GAmpt_Count=0
        except Exception as e:
           MsInfo(e)



    '''
    배열 생성하면서 임시 값을 넣음(0) 값이 3개
    xml 체크 하면서 갯수 파악해서 변수 생성함 
    만약에 해당하는 요소가 없으면 2차원 배열 [1][1] 로 생성 함 객체
    '''
    def Create_SoilDepth_Array(self,count):
        try:
            if count>0:
                self.SoilDepth_Array=[[0 for col in range(3)] for row in range(count)]
                self.SoilDepth_Count=count
            else:
                self.SoilDepth_Array=[[0 for col in range(1)] for row in range(1)]
                self.SoilDepth_Count=0
        except Exception as e:
           MsInfo(e)



    '''
    배열 생성하면서 임시 값을 넣음(0) 값이 5개
    xml 체크 하면서 갯수 파악해서 변수 생성함 
    만약에 해당하는 요소가 없으면 2차원 배열 [1][1] 로 생성 함 객체
    '''
    def Create_LandCover_Array(self,count):
        try:
            if count>0:
                self.LandCover_Array=[[0 for col in range(5)] for row in range(count)]
                self.LandCoverCount=count
            else:
                self.LandCover_Array=[[0 for col in range(1)] for row in range(1)]
                self.LandCoverCount=0
        except Exception as e:
           MsInfo(e)
