﻿# codes to implement the class in grm.dll
import ctypes
import ctypes.util
import enum
import os
import sys
from ctypes import Structure


class unSaturatedKType(enum.Enum):
    Constant = 0
    Linear = 1
    Exponential = 2
    usKNone = 3


class PETmethod(enum.Enum):
    PenmanMonteith = 1
    BlaneyCriddle = 2
    Hamon = 3
    PriestleyTaylor = 4
    Hargreaves = 5
    JensenHaise = 6
    Turc = 7
    Constant = 8
    UserData = 9
    petNone = 10


class SnowMeltMethod(enum.Enum):
    Anderson = 1
    Constant = 8
    UserData = 9
    smNone = 10


class InterceptionMethod(enum.Enum):
    LAIRatio = 1
    Constant = 8
    UserData = 9
    icNone = 10


class swsParameters(Structure):
    _fields_ = [
        ("wsid", ctypes.c_int),
        ("iniSaturation", ctypes.c_double),
        ("minSlopeOF", ctypes.c_double),
        ("unSatKType", ctypes.c_int),
        ("coefUnsaturatedK", ctypes.c_double),
        ("minSlopeChBed", ctypes.c_double),
        ("minChBaseWidth", ctypes.c_double),
        ("chRoughness", ctypes.c_double),
        ("dryStreamOrder", ctypes.c_int),
        ("iniFlow", ctypes.c_double),
        ("ccLCRoughness", ctypes.c_double),
        ("ccPorosity", ctypes.c_double),
        ("ccWFSuctionHead", ctypes.c_double),
        ("ccHydraulicK", ctypes.c_double),
        ("ccSoilDepth", ctypes.c_double),
        ("interceptMethod", ctypes.c_int),
        ("potentialETMethod", ctypes.c_int),
        ("etCoeff", ctypes.c_double),
        ("snowMeltMethod", ctypes.c_int),
        ("tempSnowRain", ctypes.c_double),
        ("smeltingTemp", ctypes.c_double),
        ("snowCovRatio", ctypes.c_double),
        ("smeltCoef", ctypes.c_double),
        ("userSet", ctypes.c_int),
    ]


class grmWSinfo(object):
    def __init__(
        self,
        fpnGMP_OR_fdirType,
        fpnDomain="",
        fpnSlope="",
        fpnFdir="",
        fpnFac="",
        fpnStream="",
        fpnLandCover="",
        fpnSoilTexture="",
        fpnSoilDepth="",
        fpnIniSoilSaturationRatio="",
        pfnIniChannelFlow="",
        fpnChannelWidth="",
    ):
        dll_path = (
            os.path.dirname(os.path.realpath(__file__)).replace("lib", "")
            + "\DLL\GRM.dll"
        )
        gdl_path = ctypes.util.find_library(dll_path)

        if not gdl_path:
            print("Unable to find the specified library.")
            sys.exit()
        try:
            self.gdl = ctypes.CDLL(gdl_path)
        except OSError:
            print("Unable to load the system C library")
            sys.exit()
        self.gdl.grmWSinfo_new_inputFiles.argtypes = [
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
            ctypes.c_char_p,
        ]

        self.gdl.grmWSinfo_new_inputFiles.restype = ctypes.c_void_p
        self.gdl.grmWSinfo_new_gmpFile.argtypes = [ctypes.c_char_p]
        self.gdl.grmWSinfo_new_gmpFile.restype = ctypes.c_void_p
        self.gdl.isInWatershedArea.argtypes = [
            ctypes.c_void_p,
            ctypes.c_int,
            ctypes.c_int,
        ]
        self.gdl.isInWatershedArea.restype = ctypes.c_bool
        self.gdl.upStreamWSIDs.argtypes = [ctypes.c_void_p, ctypes.c_int]
        self.gdl.upStreamWSIDs.restype = ctypes.POINTER(ctypes.c_int)
        self.gdl.upStreamWSCount.argtypes = [ctypes.c_void_p, ctypes.c_int]
        self.gdl.upStreamWSCount.restype = ctypes.c_int
        self.gdl.downStreamWSIDs.argtypes = [ctypes.c_void_p, ctypes.c_int]
        self.gdl.downStreamWSIDs.restype = ctypes.POINTER(ctypes.c_int)
        self.gdl.downStreamWSCount.argtypes = [ctypes.c_void_p, ctypes.c_int]
        self.gdl.downStreamWSCount.restype = ctypes.c_int
        self.gdl.watershedID.argtypes = [ctypes.c_void_p, ctypes.c_int, ctypes.c_int]
        self.gdl.watershedID.restype = ctypes.c_int
        self.gdl.flowDirection.argtypes = [ctypes.c_void_p, ctypes.c_int, ctypes.c_int]
        self.gdl.flowDirection.restype = ctypes.c_char_p
        self.gdl.flowAccumulation.argtypes = [
            ctypes.c_void_p,
            ctypes.c_int,
            ctypes.c_int,
        ]
        self.gdl.flowAccumulation.restype = ctypes.c_int
        self.gdl.slope.argtypes = [ctypes.c_void_p, ctypes.c_int, ctypes.c_int]
        self.gdl.slope.restype = ctypes.c_double
        self.gdl.streamValue.argtypes = [ctypes.c_void_p, ctypes.c_int, ctypes.c_int]
        self.gdl.streamValue.restype = ctypes.c_int
        self.gdl.cellFlowTypeACell.argtypes = [
            ctypes.c_void_p,
            ctypes.c_int,
            ctypes.c_int,
        ]
        self.gdl.cellFlowTypeACell.restype = ctypes.c_char_p
        self.gdl.landCoverValue.argtypes = [ctypes.c_void_p, ctypes.c_int, ctypes.c_int]
        self.gdl.landCoverValue.restype = ctypes.c_int
        self.gdl.soilTextureValue.argtypes = [
            ctypes.c_void_p,
            ctypes.c_int,
            ctypes.c_int,
        ]
        self.gdl.soilTextureValue.restype = ctypes.c_int
        self.gdl.soilDepthValue.argtypes = [ctypes.c_void_p, ctypes.c_int, ctypes.c_int]
        self.gdl.soilDepthValue.restype = ctypes.c_int
        self.gdl.cellCountInUpstreamArea.argtypes = [
            ctypes.c_void_p,
            ctypes.c_int,
            ctypes.c_int,
        ]
        self.gdl.cellCountInUpstreamArea.restype = ctypes.c_int
        self.gdl.allCellsInUpstreamArea.argtypes = [
            ctypes.c_void_p,
            ctypes.c_int,
            ctypes.c_int,
        ]
        self.gdl.allCellsInUpstreamArea.restype = ctypes.POINTER(ctypes.c_char_p)
        self.gdl.setOneSWSParsAndUpdateAllSWSUsingNetwork.argtypes = [
            ctypes.c_void_p,
            ctypes.c_int,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_int,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_int,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_int,
            ctypes.c_int,
            ctypes.c_double,
            ctypes.c_int,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
            ctypes.c_double,
        ]

        self.gdl.setOneSWSParsAndUpdateAllSWSUsingNetwork.restype = ctypes.c_bool
        self.gdl.updateAllSubWatershedParametersUsingNetwork.argtypes = [
            ctypes.c_void_p
        ]
        self.gdl.updateAllSubWatershedParametersUsingNetwork.restype = None
        self.gdl.subwatershedPars.argtypes = [ctypes.c_void_p, ctypes.c_int]
        self.gdl.subwatershedPars.restype = swsParameters
        self.gdl.removeUserParametersSetting.argtypes = [ctypes.c_void_p, ctypes.c_int]
        self.gdl.removeUserParametersSetting.restype = ctypes.c_bool
        self.gdl.facMaxCellxCol.argtypes = [ctypes.c_void_p]
        self.gdl.facMaxCellxCol.restype = ctypes.c_int
        self.gdl.facMaxCellyRow.argtypes = [ctypes.c_void_p]
        self.gdl.facMaxCellyRow.restype = ctypes.c_int
        self.gdl.WSIDsAll.argtypes = [ctypes.c_void_p]
        self.gdl.WSIDsAll.restype = ctypes.POINTER(ctypes.c_int)
        self.gdl.WScount.argtypes = [ctypes.c_void_p]
        self.gdl.WScount.restype = ctypes.c_int
        self.gdl.mostDownStreamWSIDs.argtypes = [ctypes.c_void_p]
        self.gdl.mostDownStreamWSIDs.restype = ctypes.POINTER(ctypes.c_int)
        self.gdl.mostDownStreamWSCount.argtypes = [ctypes.c_void_p]
        self.gdl.mostDownStreamWSCount.restype = ctypes.c_int
        self.gdl.cellCountInWatershed.argtypes = [ctypes.c_void_p]
        self.gdl.cellCountInWatershed.restype = ctypes.c_int
        self.gdl.cellSize.argtypes = [ctypes.c_void_p]
        self.gdl.cellSize.restype = ctypes.c_double
        self.gdl.FDtype.argtypes = [ctypes.c_void_p]
        self.gdl.FDtype.restype = ctypes.c_char_p
        bfpnGmpORfdirType = fpnGMP_OR_fdirType.encode("utf-8")

        if fpnDomain == "":
            self.obj = self.gdl.grmWSinfo_new_gmpFile(bfpnGmpORfdirType)
        else:
            bfpnDomain = fpnDomain.encode("utf-8")
            bfpnSlope = fpnSlope.encode("utf-8")
            bfpnFdir = fpnFdir.encode("utf-8")
            bfpnFac = fpnFac.encode("utf-8")
            bfpnStream = fpnStream.encode("utf-8")
            bfpnLandCover = fpnLandCover.encode("utf-8")
            bfpnSoilTexture = fpnSoilTexture.encode("utf-8")
            bfpnSoilDepth = fpnSoilDepth.encode("utf-8")
            bfpnIniSoilSaturationRatio = fpnIniSoilSaturationRatio.encode("utf-8")
            bpfnIniChannelFlow = pfnIniChannelFlow.encode("utf-8")
            bfpnChannelWidth = fpnChannelWidth.encode("utf-8")
            self.obj = self.gdl.grmWSinfo_new_inputFiles(
                bfpnGmpORfdirType,
                bfpnDomain,
                bfpnSlope,
                bfpnFdir,
                bfpnFac,
                bfpnStream,
                bfpnLandCover,
                bfpnSoilTexture,
                bfpnSoilDepth,
                bfpnIniSoilSaturationRatio,
                bpfnIniChannelFlow,
                bfpnChannelWidth,
            )

        self.facMaxCellxCol = self.gdl.facMaxCellxCol(self.obj)
        self.facMaxCellyRow = self.gdl.facMaxCellyRow(self.obj)
        self.WSIDsAll = self.gdl.WSIDsAll(self.obj)
        self.WScount = self.gdl.WScount(self.obj)
        self.mostDownStreamWSIDs = self.gdl.mostDownStreamWSIDs(self.obj)
        self.mostDownStreamWSCount = self.gdl.mostDownStreamWSCount(self.obj)
        self.cellCountInWatershed = self.gdl.cellCountInWatershed(self.obj)
        self.cellSize = self.gdl.cellSize(self.obj)
        self.fdType_fromGMP = self.gdl.FDtype(self.obj)

    def disconnect_dll(self):
        handle = self.gdl._handle
        try:
            ctypes.windll.kernel32.FreeLibrary(handle)
        except (ctypes.ArgumentError, OverflowError):  # 64-bit Python
            kernel32 = ctypes.WinDLL("kernel32", use_last_error=True)
            kernel32.FreeLibrary.argtypes = [ctypes.wintypes.HMODULE]
            kernel32.FreeLibrary(handle)

    def isInWatershedArea(self, colXAryidx, rowYAryidx):
        return self.gdl.isInWatershedArea(self.obj, colXAryidx, rowYAryidx)

    def upStreamWSIDs(self, currentWSID):
        return self.gdl.upStreamWSIDs(self.obj, currentWSID)

    def upStreamWSCount(self, currentWSID):
        return self.gdl.upStreamWSCount(self.obj, currentWSID)

    def downStreamWSIDs(self, currentWSID):
        return self.gdl.downStreamWSIDs(self.obj, currentWSID)

    def downStreamWSCount(self, currentWSID):
        return self.gdl.downStreamWSCount(self.obj, currentWSID)

    def watershedID(self, colXAryidx, rowYAryidx):
        return self.gdl.watershedID(self.obj, colXAryidx, rowYAryidx)

    def flowDirection(self, colXAryidx, rowYAryidx):
        return self.gdl.flowDirection(self.obj, colXAryidx, rowYAryidx)

    def flowAccumulation(self, colXAryidx, rowYAryidx):
        return self.gdl.flowAccumulation(self.obj, colXAryidx, rowYAryidx)

    def slope(self, colXAryidx, rowYAryidx):
        return self.gdl.slope(self.obj, colXAryidx, rowYAryidx)

    def streamValue(self, colXAryidx, rowYAryidx):
        return self.gdl.streamValue(self.obj, colXAryidx, rowYAryidx)

    def cellFlowTypeACell(self, colXAryidx, rowYAryidx):
        return self.gdl.cellFlowTypeACell(self.obj, colXAryidx, rowYAryidx)

    def landCoverValue(self, colXAryidx, rowYAryidx):
        return self.gdl.landCoverValue(self.obj, colXAryidx, rowYAryidx)

    def soilTextureValue(self, colXAryidx, rowYAryidx):
        return self.gdl.soilTextureValue(self.obj, colXAryidx, rowYAryidx)

    def soilDepthValue(self, colXAryidx, rowYAryidx):
        return self.gdl.soilDepthValue(self.obj, colXAryidx, rowYAryidx)

    def allCellsInUpstreamArea(self, colXAryidx, rowYAryidx):
        return self.gdl.allCellsInUpstreamArea(self.obj, colXAryidx, rowYAryidx)

    def cellCountInUpstreamArea(self, colXAryidx, rowYAryidx):
        return self.gdl.cellCountInUpstreamArea(self.obj, colXAryidx, rowYAryidx)

    def setOneSWSParsAndUpdateAllSWSUsingNetwork(
        self,
        wsid,
        iniSat,
        minSlopeLandSurface,
        unSKType,
        coefUnsK,
        minSlopeChannel,
        minChannelBaseWidth,
        roughnessChannel,
        dryStreamOrder,
        ccLCRoughness,
        ccPorosity,
        ccWFSuctionHead,
        ccSoilHydraulicCond,
        ccSoilDepth,  # 이 변수 위치 변경됨. 여기로 이동. 2023.03.02
        # ==========추가됨. 2023.03.02===
        interceptMethod,
        potentialETMethod,
        etCoeff,
        snowMeltMethod,
        tempSnowRain,
        smeltingTemp,
        snowCovRatio,
        smeltCoef,
        # =========================
        iniFlow=0.0,
    ):
        return self.gdl.setOneSWSParsAndUpdateAllSWSUsingNetwork(
            self.obj,
            wsid,
            iniSat,
            minSlopeLandSurface,
            unSKType,
            coefUnsK,
            minSlopeChannel,
            minChannelBaseWidth,
            roughnessChannel,
            dryStreamOrder,
            ccLCRoughness,
            ccPorosity,
            ccWFSuctionHead,
            ccSoilHydraulicCond,
            ccSoilDepth,  # 이 변수 위치 변경됨. 여기로 이동. 2023.03.02
            # ==========추가됨. 2023.03.02===
            interceptMethod,
            potentialETMethod,
            etCoeff,
            snowMeltMethod,
            tempSnowRain,
            smeltingTemp,
            snowCovRatio,
            smeltCoef,
            # =========================
            iniFlow,
        )

    def updateAllSubWatershedParametersUsingNetwork(self):
        return self.gdl.updateAllSubWatershedParametersUsingNetwork(self.obj)

    def subwatershedPars(self, wsid):
        return self.gdl.subwatershedPars(self.obj, wsid)

    def removeUserParametersSetting(self, wsid):
        return self.gdl.removeUserParametersSetting(self.obj, wsid)
