# -*- coding: utf-8 -*-
from math import ceil

from qgis.core import *
from qgis.gui import *
from PyQt5.QtWidgets import *

def get_point_layer(map_layer, canvas):

    xmin, ymin, xmax, ymax = map_layer.extent().toRectF().getCoords()
    crs = map_layer.crs().toWkt()
    point_layer = QgsVectorLayer('Polygon?crs=' + crs, 'grid_line', 'memory')
    point_provider = point_layer.dataProvider()

    gridWidth =map_layer.rasterUnitsPerPixelX()       #2017.11.1 원영진 수정
    gridHeight = map_layer.rasterUnitsPerPixelY()     #2017.11.1 원영진 수정

    rows = ceil((ymax-ymin)/gridHeight)
    cols = ceil((xmax-xmin)/gridWidth)
    ringXleftOrigin = xmin
    ringXrightOrigin = xmin + gridWidth
    ringYtopOrigin = ymax
    ringYbottomOrigin = ymax-gridHeight
    for i in range(int(cols)):
        ringYtop = ringYtopOrigin
        ringYbottom =ringYbottomOrigin
        for j in range(int(rows)):
            poly = [QgsPointXY(ringXleftOrigin, ringYtop),QgsPointXY(ringXrightOrigin, ringYtop),QgsPointXY(ringXrightOrigin, ringYbottom),QgsPointXY(ringXleftOrigin, ringYbottom),QgsPointXY(ringXleftOrigin, ringYtop)] 
            feat = QgsFeature()
            feat.setGeometry(QgsGeometry().fromPolygonXY([poly]))
            point_provider.addFeatures([feat])
            point_layer.updateExtents()

            ringYtop = ringYtop - gridHeight
            ringYbottom = ringYbottom - gridHeight
        ringXleftOrigin = ringXleftOrigin + gridWidth
        ringXrightOrigin = ringXrightOrigin + gridWidth


    myRenderer = point_layer.renderer()

    if point_layer.geometryType() == 2:

        # 2017-12-07 박 두께 및 색상 변경
        properties = {'color': '255,0,0,0','width_border': '0.09' , 'color_border': '0,0,0,127'}
        mySymbol1 = QgsFillSymbol.createSimple(properties)

    myRenderer.setSymbol(mySymbol1)
    point_layer.triggerRepaint()

    return point_layer