# -*- coding: utf-8 -*-

import xml.etree.ElementTree as ET

from grm.lib.Util import indent

# from .lib.File_Class import *
# from .lib.Util import *


class xmls:
    def __init__(self):
        self.ProjectFile = ""
        self.CrossSectionType = []
        self.SingleCSChannelWidthType = []
        self.ChannelWidthEQc = []
        self.ChannelWidthEQd = []
        self.ChannelWidthEQe = []
        self.ChannelWidthMostDownStream = []
        self.LowerRegionHeight = []
        self.LowerRegionBaseWidth = []
        self.UpperRegionBaseWidth = []
        self.CompoundCSChannelWidthLimit = []
        self.BankSideSlopeRight = []
        self.BankSideSlopeLeft = []
        self.XML_element_remove = []
        self.check_ChannelSettings = False

    def Check_Gmp_xml(self, filepath):
        self.ProjectFile = filepath
        # xml 요소 값을 배열에 넣음
        self.Set_XML_element()
        self.Set_XML_element_SubWatershed()
        self.Set_XML_element_WatchPoints()
        self.Set_XML_element_FlowControlGrid()
        self.Set_XML_element_GreenAmptParameter()
        self.Set_XML_element_SoilDepth()
        self.Set_XML_element_LandCover()

        # 2020-04-21 박: 신규 추가
        self.Set_XML_element_ChannelSettings()

        # xml 파싱
        doc = ET.parse(self.ProjectFile)
        root = doc.getroot()
        GRMProject = ET.Element("GRMProject")
        GRMProject.set("xmlns", "http://tempuri.org/GRMProject.xsd")

        rootValue = root.findall("{http://tempuri.org/GRMProject.xsd}ProjectSettings")
        for element in rootValue:
            ProjectSettings = ET.SubElement(GRMProject, "ProjectSettings")
            flag_WatershedFile = True
            for i in range(0, len(self.XML_element)):
                Datavalue = element.findtext(
                    "{http://tempuri.org/GRMProject.xsd}" + self.XML_element[i]
                )
                if self.XML_element[i] == "GRMSimulationType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "SingleEvent"
                if self.XML_element[i] == "LandCoverDataType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "File"
                if self.XML_element[i] == "SoilTextureDataType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "File"
                if self.XML_element[i] == "SoilDepthDataType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "File"
                if self.XML_element[i] == "FlowDirectionType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "StartsFromE_TauDEM"
                if self.XML_element[i] == "MaxDegreeOfParallelism" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "-1"
                if self.XML_element[i] == "SimulationStartingTime" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                if self.XML_element[i] == "IsFixedTimeStep" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "false"
                if self.XML_element[i] == "'SimulateInfiltration'" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "SimulateSubsurfaceFlow" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "SimulateBaseFlow" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "SimulateInterception" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "SimulateEvapotranspiration" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "SimulateSnowMelt" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "SimulateFlowControl" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"

                # 2020-04-21 박: <ChannelSettings> 로 이동함
                # 2020-07-15 박: <ChannelSettings> 기본 값이 없으면 처리 안하게 처리
                try:
                    if self.XML_element[i] == "CrossSectionType" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.CrossSectionType.append("CSSingle")
                        rootValue.remove(element)
                        self.check_ChannelSettings = False
                    elif self.XML_element[i] == "CrossSectionType" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.CrossSectionType.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "SingleCSChannelWidthType" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.SingleCSChannelWidthType.append("CWGeneration")
                        rootValue.remove(element)
                        self.check_ChannelSettings = False
                    elif self.XML_element[i] == "SingleCSChannelWidthType" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.SingleCSChannelWidthType.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "ChannelWidthEQc" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.ChannelWidthEQc.append("1.698")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "ChannelWidthEQc" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.ChannelWidthEQc.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "ChannelWidthEQd" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.ChannelWidthEQd.append("0.318")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "ChannelWidthEQd" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.ChannelWidthEQd.append(Datavalue)
                        rootValue.remove(element)

                    if self.XML_element[i] == "ChannelWidthEQe" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.ChannelWidthEQe.append("0.5")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "ChannelWidthEQe" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.ChannelWidthEQe.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "ChannelWidthMostDownStream" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.ChannelWidthMostDownStream.append("400")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "ChannelWidthMostDownStream" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.ChannelWidthMostDownStream.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "LowerRegionHeight" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.LowerRegionHeight.append("0")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "LowerRegionHeight" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.LowerRegionHeight.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "LowerRegionBaseWidth" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.LowerRegionBaseWidth.append("0")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "LowerRegionBaseWidth" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.LowerRegionBaseWidth.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "UpperRegionBaseWidth" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.UpperRegionBaseWidth.append("0")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "UpperRegionBaseWidth" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.UpperRegionBaseWidth.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "CompoundCSChannelWidthLimit" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.CompoundCSChannelWidthLimit.append("0")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "CompoundCSChannelWidthLimit" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.CompoundCSChannelWidthLimit.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "BankSideSlopeRight" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.BankSideSlopeRight.append("1.5")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "BankSideSlopeRight" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.BankSideSlopeRight.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True

                    if self.XML_element[i] == "BankSideSlopeLeft" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        self.BankSideSlopeLeft.append("1.5")
                        self.check_ChannelSettings = False
                        rootValue.remove(element)
                    elif self.XML_element[i] == "BankSideSlopeLeft" and (
                        Datavalue != "" and Datavalue is not None
                    ):
                        self.BankSideSlopeLeft.append(Datavalue)
                        rootValue.remove(element)
                        self.check_ChannelSettings = True
                except Exception:
                    pass
                if self.XML_element[i] == "MakeIMGFile" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "false"
                if self.XML_element[i] == "MakeASCFile" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "false"
                if self.XML_element[i] == "MakeSoilSaturationDistFile" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "MakeRfDistFile" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "MakeRFaccDistFile" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "MakeFlowDistFile" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "true"
                if self.XML_element[i] == "PrintOption" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "All"
                if self.XML_element[i] == "PrintAveValue" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "false"
                if self.XML_element[i] == "WriteLog" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "false"

                if self.XML_element[i] == "WatershedFile":
                    rootValue.remove(element)
                    if Datavalue != "" and Datavalue is not None:
                        ET.SubElement(ProjectSettings, "DomainFile").text = Datavalue
                        flag_WatershedFile = False
                elif self.XML_element[i] == "DomainFile":
                    if flag_WatershedFile:
                        ET.SubElement(
                            ProjectSettings, self.XML_element[i]
                        ).text = Datavalue
                else:
                    if not (self.XML_element[i] in self.XML_element_remove):
                        ET.SubElement(
                            ProjectSettings, self.XML_element[i]
                        ).text = Datavalue

        self._SubWatershedCount = 0
        for element in root.findall(
            "{http://tempuri.org/GRMProject.xsd}SubWatershedSettings"
        ):
            SubWatershedSettings = ET.SubElement(GRMProject, "SubWatershedSettings")
            for i in range(0, len(self.XML_element_SubWatershed)):
                Datavalue = element.findtext(
                    "{http://tempuri.org/GRMProject.xsd}"
                    + self.XML_element_SubWatershed[i]
                )
                if self.XML_element_SubWatershed[i] == "IniSaturation" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0.9"
                elif self.XML_element_SubWatershed[i] == "MinSlopeOF" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0.0001"
                elif self.XML_element_SubWatershed[i] == "MinSlopeChBed" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0.0001"
                elif self.XML_element_SubWatershed[i] == "MinChBaseWidth" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "00"
                elif self.XML_element_SubWatershed[i] == "ChRoughness" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0.045"
                elif self.XML_element_SubWatershed[i] == "DryStreamOrder" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                elif self.XML_element_SubWatershed[i] == "IniFlow" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                elif self.XML_element_SubWatershed[i] == "UnsaturatedKType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "Linear"
                elif self.XML_element_SubWatershed[i] == "CoefUnsaturatedK" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0.2"
                elif self.XML_element_SubWatershed[i] == "CalCoefLCRoughness" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "CalCoefPorosity" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "CalCoefWFSuctionHead" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "CalCoefHydraulicK" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "CalCoefSoilDepth" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "InterceptionMethod" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "None"
                elif self.XML_element_SubWatershed[i] == "PETMethod" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "None"
                elif self.XML_element_SubWatershed[i] == "ETCoef" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "SnowmeltMethod" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "None"
                elif self.XML_element_SubWatershed[i] == "TempSnowRain" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "SnowmeltingTemp" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "SnowCovRatio" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                elif self.XML_element_SubWatershed[i] == "SnowmeltCoef" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "1"
                if self.XML_element_SubWatershed[i] == "UserSet" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "false"
                ET.SubElement(
                    SubWatershedSettings, self.XML_element_SubWatershed[i]
                ).text = Datavalue
            self._SubWatershedCount = self._SubWatershedCount + 1

        self._WatchPointCount = 0
        for element in root.findall("{http://tempuri.org/GRMProject.xsd}WatchPoints"):
            WatchPoints = ET.SubElement(GRMProject, "WatchPoints")
            for i in range(0, len(self.XML_element_WatchPoints)):
                Datavalue = element.findtext(
                    "{http://tempuri.org/GRMProject.xsd}"
                    + self.XML_element_WatchPoints[i]
                )
                if self.XML_element_WatchPoints[i] == "Name" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_WatchPoints[i] == "ColX" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_WatchPoints[i] == "RowY" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                ET.SubElement(
                    WatchPoints, self.XML_element_WatchPoints[i]
                ).text = Datavalue
            self._WatchPointCount = self._WatchPointCount + 1

        self._FlowControlCount = 0
        for element in root.findall(
            "{http://tempuri.org/GRMProject.xsd}FlowControlGrid"
        ):
            FlowControlGrid = ET.SubElement(GRMProject, "FlowControlGrid")
            for i in range(0, len(self.XML_element_FlowControlGrid)):
                Datavalue = element.findtext(
                    "{http://tempuri.org/GRMProject.xsd}"
                    + self.XML_element_FlowControlGrid[i]
                )
                if self.XML_element_FlowControlGrid[i] == "ColX" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "RowY" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "Name" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "ControlType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "FlowDataFile" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "DT_min" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "IniStorage" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "MaxStorage" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                if self.XML_element_FlowControlGrid[i] == "NormalHighStorage" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                if self.XML_element_FlowControlGrid[i] == "RestrictedStorage" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                if self.XML_element_FlowControlGrid[i] == "RestrictedPeriod_Start" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                if self.XML_element_FlowControlGrid[i] == "RestrictedPeriod_End" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = "0"
                if self.XML_element_FlowControlGrid[i] == "ROType" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "AutoROMmaxOutflow_CMS" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "ROConstQ" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                if self.XML_element_FlowControlGrid[i] == "ROConstQDuration" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""
                ET.SubElement(
                    FlowControlGrid, self.XML_element_FlowControlGrid[i]
                ).text = Datavalue
            self._FlowControlCount = self._FlowControlCount + 1

        self._GreenAmptCount = 0
        rootValue = root.findall(
            "{http://tempuri.org/GRMProject.xsd}GreenAmptParameter"
        )
        for element in rootValue:
            GreenAmptParameter = ET.SubElement(GRMProject, "GreenAmptParameter")
            for i in range(0, len(self.XML_element_GreenAmptParameter)):
                Datavalue = element.findtext(
                    "{http://tempuri.org/GRMProject.xsd}"
                    + self.XML_element_GreenAmptParameter[i]
                )
                if self.XML_element_GreenAmptParameter[i] == "GridValue" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_GreenAmptParameter[i] == "USERSoil" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_GreenAmptParameter[i] == "GRMCode" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                # if self.XML_element_GreenAmptParameter[i] == "GRMTextureE":
                #    rootValue.remove(element)
                # if self.XML_element_GreenAmptParameter[i] == "GRMTextureK" :
                #    rootValue.remove(element)

                if self.XML_element_GreenAmptParameter[i] == "Porosity" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_GreenAmptParameter[i] == "EffectivePorosity" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_GreenAmptParameter[i] == "WFSoilSuctionHead" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_GreenAmptParameter[
                    i
                ] == "HydraulicConductivity" and (Datavalue == "" or Datavalue is None):
                    Datavalue = ""

                ET.SubElement(
                    GreenAmptParameter, self.XML_element_GreenAmptParameter[i]
                ).text = Datavalue
            self._GreenAmptCount = self._GreenAmptCount + 1

        self._SoilDepthCount = 0
        rootValue = root.findall("{http://tempuri.org/GRMProject.xsd}SoilDepth")

        for element in rootValue:
            SoilDepth = ET.SubElement(GRMProject, "SoilDepth")
            for i in range(0, len(self.XML_element_SoilDepth)):
                Datavalue = element.findtext(
                    "{http://tempuri.org/GRMProject.xsd}"
                    + self.XML_element_SoilDepth[i]
                )
                if self.XML_element_SoilDepth[i] == "GridValue" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_SoilDepth[i] == "UserDepthClass" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_SoilDepth[i] == "GRMCode" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                # if self.XML_element_SoilDepth[i] == "SoilDepthClassE":
                #    rootValue.remove(element)
                # if self.XML_element_SoilDepth[i] == "SoilDepthClassK":
                #    rootValue.remove(element)

                if self.XML_element_SoilDepth[i] == "SoilDepth":
                    if Datavalue != "" and Datavalue is not None:
                        ET.SubElement(SoilDepth, "SoilDepth_cm").text = Datavalue
                        flag_soildepth = False
                    else:
                        flag_soildepth = True

                elif self.XML_element_SoilDepth[i] == "SoilDepth_cm":
                    if flag_soildepth:
                        ET.SubElement(
                            SoilDepth, self.XML_element_SoilDepth[i]
                        ).text = Datavalue
                else:
                    ET.SubElement(
                        SoilDepth, self.XML_element_SoilDepth[i]
                    ).text = Datavalue

                # if self.XML_element_SoilDepth[i] == "SoilDepth_cm" :
                #     if Datavalue == "" or Datavalue is None:
                #         Datavalue = ""
                #     ET.SubElement(SoilDepth, "SoilDepth_cm").text = Datavalue
                # elif self.XML_element_SoilDepth[i] == "SoilDepth_cm":
                #     if Datavalue == "" or Datavalue is None:
                #         Datavalue = ""
                #     ET.SubElement(SoilDepth, "SoilDepth_cm").text = Datavalue

                # ET.SubElement(SoilDepth, self.XML_element_SoilDepth[i]).text = Datavalue
            self._SoilDepthCount = self._SoilDepthCount + 1

        self._LandCoverCount = 0
        rootValue = root.findall("{http://tempuri.org/GRMProject.xsd}LandCover")
        for element in rootValue:
            LandCover = ET.SubElement(GRMProject, "LandCover")
            for i in range(0, len(self.XML_element_LandCover)):
                Datavalue = element.findtext(
                    "{http://tempuri.org/GRMProject.xsd}"
                    + self.XML_element_LandCover[i]
                )
                if self.XML_element_LandCover[i] == "GridValue" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_LandCover[i] == "UserLandCover" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_LandCover[i] == "GRMCode" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                # if self.XML_element_LandCover[i] == "GRMLandCoverE" :
                #    rootValue.remove(element)
                # if self.XML_element_LandCover[i] == "GRMLandCoverK":
                #    rootValue.remove(element)

                if self.XML_element_LandCover[i] == "RoughnessCoefficient" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_LandCover[i] == "ImperviousRatio" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_LandCover[i] == "CanopyRatio" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                if self.XML_element_LandCover[
                    i
                ] == "InterceptionMaxWaterCanopy_mm" and (
                    Datavalue == "" or Datavalue is None
                ):
                    Datavalue = ""

                ET.SubElement(LandCover, self.XML_element_LandCover[i]).text = Datavalue
            self._LandCoverCount = self._LandCoverCount + 1

        self._ChannelSettingsCount = 0
        # 2020-06-03 박: 오래된 GMP 파일이면 분리해서 새로 생성 함
        Channel_Count = len(
            root.findall("{http://tempuri.org/GRMProject.xsd}ChannelSettings")
        )

        if Channel_Count > 0:
            for element in root.findall(
                "{http://tempuri.org/GRMProject.xsd}ChannelSettings"
            ):
                ChannelSettings = ET.SubElement(GRMProject, "ChannelSettings")
                for i in range(0, len(self.XML_element_ChannelSettings)):
                    Datavalue = element.findtext(
                        "{http://tempuri.org/GRMProject.xsd}"
                        + self.XML_element_ChannelSettings[i]
                    )
                    if self.XML_element_ChannelSettings[i] == "WSID" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = ""
                    if self.XML_element_ChannelSettings[i] == "CrossSectionType" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "CSSingle"
                    if self.XML_element_ChannelSettings[
                        i
                    ] == "SingleCSChannelWidthType" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "CWGeneration"
                    if self.XML_element_ChannelSettings[i] == "ChannelWidthEQc" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "1.698"
                    if self.XML_element_ChannelSettings[i] == "ChannelWidthEQd" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "0.318"
                    if self.XML_element_ChannelSettings[i] == "ChannelWidthEQe" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "0.5"
                    if self.XML_element_ChannelSettings[
                        i
                    ] == "ChannelWidthMostDownStream" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "400"
                    if self.XML_element_ChannelSettings[i] == "LowerRegionHeight" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "0"
                    if self.XML_element_ChannelSettings[
                        i
                    ] == "LowerRegionBaseWidth" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "0"
                    if self.XML_element_ChannelSettings[
                        i
                    ] == "UpperRegionBaseWidth" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "0"
                    if self.XML_element_ChannelSettings[
                        i
                    ] == "CompoundCSChannelWidthLimit" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "0"
                    if self.XML_element_ChannelSettings[i] == "BankSideSlopeRight" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "1.5"
                    if self.XML_element_ChannelSettings[i] == "BankSideSlopeLeft" and (
                        Datavalue == "" or Datavalue is None
                    ):
                        Datavalue = "1.5"
                    ET.SubElement(
                        ChannelSettings, self.XML_element_ChannelSettings[i]
                    ).text = Datavalue
                self._ChannelSettingsCount = self._ChannelSettingsCount + 1

        # 2020-07-15 박: 기본 값이 없을때도 생성됨 기본값은 있어서는 안됨
        elif Channel_Count == 0:
            if self.check_ChannelSettings:
                ChannelSettings = ET.SubElement(GRMProject, "ChannelSettings")
                for i in range(0, len(self.XML_element_ChannelSettings)):
                    if self.XML_element_ChannelSettings[i] == "WSID":
                        Datavalue = "1"

                    if self.XML_element_ChannelSettings[i] == "CrossSectionType":
                        Datavalue = self.CrossSectionType[0]

                    if (
                        self.XML_element_ChannelSettings[i]
                        == "SingleCSChannelWidthType"
                    ):
                        Datavalue = self.SingleCSChannelWidthType[0]

                    if self.XML_element_ChannelSettings[i] == "ChannelWidthEQc":
                        Datavalue = self.ChannelWidthEQc[0]

                    if self.XML_element_ChannelSettings[i] == "ChannelWidthEQd":
                        Datavalue = self.ChannelWidthEQd[0]

                    if self.XML_element_ChannelSettings[i] == "ChannelWidthEQe":
                        Datavalue = self.ChannelWidthEQe[0]

                    if (
                        self.XML_element_ChannelSettings[i]
                        == "ChannelWidthMostDownStream"
                    ):
                        Datavalue = self.ChannelWidthMostDownStream[0]

                    if self.XML_element_ChannelSettings[i] == "LowerRegionHeight":
                        Datavalue = self.LowerRegionHeight[0]

                    if self.XML_element_ChannelSettings[i] == "LowerRegionBaseWidth":
                        Datavalue = self.LowerRegionBaseWidth[0]

                    if self.XML_element_ChannelSettings[i] == "UpperRegionBaseWidth":
                        Datavalue = self.UpperRegionBaseWidth[0]

                    if (
                        self.XML_element_ChannelSettings[i]
                        == "CompoundCSChannelWidthLimit"
                    ):
                        Datavalue = self.CompoundCSChannelWidthLimit[0]

                    if self.XML_element_ChannelSettings[i] == "BankSideSlopeRight":
                        Datavalue = self.BankSideSlopeRight[0]

                    if self.XML_element_ChannelSettings[i] == "BankSideSlopeLeft":
                        Datavalue = self.BankSideSlopeLeft[0]

                    ET.SubElement(
                        ChannelSettings, self.XML_element_ChannelSettings[i]
                    ).text = Datavalue
                self._ChannelSettingsCount = self._ChannelSettingsCount + 1

        #         ET.ElementTree(GRMProject).write(self.ProjectFile, encoding="utf-8", xml_declaration=True)
        #         self.indent(self.ProjectFile)

        root = ET.ElementTree(GRMProject).getroot()
        indent(root)
        ET.ElementTree(GRMProject).write(
            self.ProjectFile, encoding="utf-8", xml_declaration=True
        )

    #     def indent(self,Pro_path):
    #         arg=GetScriptDirectory_Path()+ "/ReWriteXML/ReadAndWriteXML.exe " + Pro_path
    #         callExecute(arg)

    def Set_XML_element(self):
        self.XML_element = []

        self.XML_element.append("ProjectFile")
        self.XML_element.append("GRMSimulationType")
        self.XML_element.append("WatershedFile")
        self.XML_element.append("DomainFile")
        self.XML_element.append("SlopeFile")
        self.XML_element.append("FlowDirectionFile")
        self.XML_element.append("FlowAccumFile")
        self.XML_element.append("StreamFile")
        self.XML_element.append("ChannelWidthFile")
        self.XML_element.append("InitialSoilSaturationRatioFile")
        self.XML_element.append("LandCoverDataType")
        self.XML_element.append("LandCoverFile")
        self.XML_element.append("LandCoverVATFile")
        self.XML_element.append("ConstantRoughnessCoeff")
        self.XML_element.append("ConstantImperviousRatio")
        self.XML_element.append("LAIFile")
        self.XML_element.append("BlaneyCriddleCoefDataFile")
        self.XML_element.append("SoilTextureDataType")
        self.XML_element.append("SoilTextureFile")
        self.XML_element.append("SoilTextureVATFile")
        self.XML_element.append("ConstantSoilPorosity")
        self.XML_element.append("ConstantSoilEffPorosity")
        self.XML_element.append("ConstantSoilWettingFrontSuctionHead")
        self.XML_element.append("ConstantSoilHydraulicConductivity")
        self.XML_element.append("SoilDepthDataType")
        self.XML_element.append("SoilDepthFile")
        self.XML_element.append("SoilDepthVATFile")
        self.XML_element.append("ConstantSoilDepth")
        self.XML_element.append("InitialChannelFlowFile")
        self.XML_element.append("PrecipitationDataFile")
        self.XML_element.append("PrecipitationInterval_min")
        self.XML_element.append("TemperatureMaxDataFile")
        self.XML_element.append("TemperatureMaxInterval_min")
        self.XML_element.append("TemperatureMinDataFile")
        self.XML_element.append("TemperatureMinInterval_min")
        self.XML_element.append("DaytimeLengthDataFile")
        self.XML_element.append("DaytimeLengthInterval_min")
        self.XML_element.append("DaytimeHoursRatioDataFile")
        self.XML_element.append("SolarRadiationDataFile")
        self.XML_element.append("SolarRadiationInterval_min")
        self.XML_element.append("SnowPackTemperatureDataFile")
        self.XML_element.append("SnowPackTemperatureInterval_min")
        self.XML_element.append("FlowDirectionType")
        #         self.XML_element.append('IsParallel')
        self.XML_element.append("MaxDegreeOfParallelism")
        self.XML_element.append("SimulationStartingTime")
        self.XML_element.append("ComputationalTimeStep_min")
        self.XML_element.append("IsFixedTimeStep")
        self.XML_element.append("SimulationDuration_hr")
        self.XML_element.append("OutputTimeStep_min")
        self.XML_element.append("SimulateInfiltration")
        self.XML_element.append("SimulateSubsurfaceFlow")
        self.XML_element.append("SimulateBaseFlow")
        self.XML_element.append("SimulateInterception")
        self.XML_element.append("SimulateEvapotranspiration")
        self.XML_element.append("SimulateSnowMelt")
        self.XML_element.append("SimulateFlowControl")

        # 2020-04-21 박: GMP 파일변경 ChannelSettings로 이동 함
        # (최하류 유역이 여러개 일수 도 있음)
        self.XML_element.append("CrossSectionType")
        self.XML_element.append("SingleCSChannelWidthType")
        self.XML_element.append("ChannelWidthEQc")
        self.XML_element.append("ChannelWidthEQd")
        self.XML_element.append("ChannelWidthEQe")
        self.XML_element.append("ChannelWidthMostDownStream")
        self.XML_element.append("LowerRegionHeight")
        self.XML_element.append("LowerRegionBaseWidth")
        self.XML_element.append("UpperRegionBaseWidth")

        # 2020-04-21 박: 최박사님과 통화 (필요 없는 항목임 제외)
        # self.XML_element.append('CompoundCSIniFlowDepth')

        # 2020-04-21 박: GMP 파일변경 ChannelSettings로 이동 함
        # (최하류 유역이 여러개 일수 도 있음)
        self.XML_element.append("CompoundCSChannelWidthLimit")
        self.XML_element.append("BankSideSlopeRight")
        self.XML_element.append("BankSideSlopeLeft")

        # -----------------------------------------------------
        self.XML_element_remove.append("CrossSectionType")
        self.XML_element_remove.append("SingleCSChannelWidthType")
        self.XML_element_remove.append("ChannelWidthEQc")
        self.XML_element_remove.append("ChannelWidthEQd")
        self.XML_element_remove.append("ChannelWidthEQe")
        self.XML_element_remove.append("ChannelWidthMostDownStream")
        self.XML_element_remove.append("LowerRegionHeight")
        self.XML_element_remove.append("LowerRegionBaseWidth")
        self.XML_element_remove.append("UpperRegionBaseWidth")
        self.XML_element_remove.append("CompoundCSChannelWidthLimit")
        self.XML_element_remove.append("BankSideSlopeRight")
        self.XML_element_remove.append("BankSideSlopeLeft")

        # -----------------------------------------------------

        self.XML_element.append("MakeIMGFile")
        self.XML_element.append("MakeASCFile")
        self.XML_element.append("MakeSoilSaturationDistFile")
        self.XML_element.append("MakeRfDistFile")
        self.XML_element.append("MakeRFaccDistFile")
        self.XML_element.append("MakeFlowDistFile")
        self.XML_element.append("PrintOption")
        self.XML_element.append("PrintAveValue")
        self.XML_element.append("AveValueTimeInterval_min")
        self.XML_element.append("WriteLog")
        self.XML_element.append("AboutThisProject")
        self.XML_element.append("AboutWatershed")
        self.XML_element.append("AboutLandCoverMap")
        self.XML_element.append("AboutSoilMap")
        self.XML_element.append("AboutSoilDepthMap")
        self.XML_element.append("AboutRainfall")
        # self.XML_element.append('ProjectSavedTime')
        # self.XML_element.append('ComputerName')
        # self.XML_element.append('ComputerUserName')
        # self.XML_element.append('GRMVersion')

    def Set_XML_element_SubWatershed(self):
        self.XML_element_SubWatershed = []
        self.XML_element_SubWatershed.append("ID")
        self.XML_element_SubWatershed.append("IniSaturation")
        self.XML_element_SubWatershed.append("MinSlopeOF")
        self.XML_element_SubWatershed.append("MinSlopeChBed")
        self.XML_element_SubWatershed.append("MinChBaseWidth")
        self.XML_element_SubWatershed.append("ChRoughness")
        self.XML_element_SubWatershed.append("DryStreamOrder")
        self.XML_element_SubWatershed.append("IniFlow")
        self.XML_element_SubWatershed.append("UnsaturatedKType")
        self.XML_element_SubWatershed.append("CoefUnsaturatedK")
        self.XML_element_SubWatershed.append("CalCoefLCRoughness")
        self.XML_element_SubWatershed.append("CalCoefPorosity")
        self.XML_element_SubWatershed.append("CalCoefWFSuctionHead")
        self.XML_element_SubWatershed.append("CalCoefHydraulicK")
        self.XML_element_SubWatershed.append("CalCoefSoilDepth")
        self.XML_element_SubWatershed.append("InterceptionMethod")
        self.XML_element_SubWatershed.append("PETMethod")
        self.XML_element_SubWatershed.append("ETCoef")
        self.XML_element_SubWatershed.append("SnowmeltMethod")
        self.XML_element_SubWatershed.append("TempSnowRain")
        self.XML_element_SubWatershed.append("SnowmeltingTemp")
        self.XML_element_SubWatershed.append("SnowCovRatio")
        self.XML_element_SubWatershed.append("SnowmeltCoef")
        self.XML_element_SubWatershed.append("UserSet")

    def Set_XML_element_WatchPoints(self):
        self.XML_element_WatchPoints = []
        self.XML_element_WatchPoints.append("Name")
        self.XML_element_WatchPoints.append("ColX")
        self.XML_element_WatchPoints.append("RowY")

    def Set_XML_element_FlowControlGrid(self):
        self.XML_element_FlowControlGrid = []
        self.XML_element_FlowControlGrid.append("ColX")
        self.XML_element_FlowControlGrid.append("RowY")
        self.XML_element_FlowControlGrid.append("Name")
        self.XML_element_FlowControlGrid.append("ControlType")
        self.XML_element_FlowControlGrid.append("FlowDataFile")
        self.XML_element_FlowControlGrid.append("DT_min")
        self.XML_element_FlowControlGrid.append("IniStorage")
        self.XML_element_FlowControlGrid.append("MaxStorage")
        self.XML_element_FlowControlGrid.append("NormalHighStorage")
        self.XML_element_FlowControlGrid.append("RestrictedStorage")
        self.XML_element_FlowControlGrid.append("RestrictedPeriod_Start")
        self.XML_element_FlowControlGrid.append("RestrictedPeriod_End")
        #         self.XML_element_FlowControlGrid.append('MaxStorageR')
        self.XML_element_FlowControlGrid.append("ROType")
        self.XML_element_FlowControlGrid.append("AutoROMmaxOutflow_CMS")
        self.XML_element_FlowControlGrid.append("ROConstQ")
        self.XML_element_FlowControlGrid.append("ROConstQDuration")

    def Set_XML_element_GreenAmptParameter(self):
        self.XML_element_GreenAmptParameter = []
        self.XML_element_GreenAmptParameter.append("GridValue")
        self.XML_element_GreenAmptParameter.append("USERSoil")
        self.XML_element_GreenAmptParameter.append("GRMCode")
        self.XML_element_GreenAmptParameter.append("Porosity")
        self.XML_element_GreenAmptParameter.append("EffectivePorosity")
        self.XML_element_GreenAmptParameter.append("WFSoilSuctionHead")
        self.XML_element_GreenAmptParameter.append("HydraulicConductivity")

    def Set_XML_element_SoilDepth(self):
        self.XML_element_SoilDepth = []
        self.XML_element_SoilDepth.append("GridValue")
        self.XML_element_SoilDepth.append("UserDepthClass")
        self.XML_element_SoilDepth.append("GRMCode")
        # python 버그???  SoilDepth 상위 태그와 subelement 이름이 같으면 값이 안들어감
        # 그래서 이름 다르게 넣고 나중에 Replace
        # 2020-05-27 박:오류 수정으로 변경 처리
        self.XML_element_SoilDepth.append("SoilDepth")

        self.XML_element_SoilDepth.append("SoilDepth_cm")

    def Set_XML_element_LandCover(self):
        self.XML_element_LandCover = []
        self.XML_element_LandCover.append("GridValue")
        self.XML_element_LandCover.append("UserLandCover")
        self.XML_element_LandCover.append("GRMCode")
        self.XML_element_LandCover.append("RoughnessCoefficient")
        self.XML_element_LandCover.append("ImperviousRatio")
        self.XML_element_LandCover.append("CanopyRatio")
        self.XML_element_LandCover.append("InterceptionMaxWaterCanopy_mm")

    def Set_XML_element_ChannelSettings(self):
        self.XML_element_ChannelSettings = []
        self.XML_element_ChannelSettings.append("WSID")
        self.XML_element_ChannelSettings.append("CrossSectionType")
        self.XML_element_ChannelSettings.append("SingleCSChannelWidthType")
        self.XML_element_ChannelSettings.append("ChannelWidthEQc")
        self.XML_element_ChannelSettings.append("ChannelWidthEQd")
        self.XML_element_ChannelSettings.append("ChannelWidthEQe")
        self.XML_element_ChannelSettings.append("ChannelWidthMostDownStream")
        self.XML_element_ChannelSettings.append("LowerRegionHeight")
        self.XML_element_ChannelSettings.append("LowerRegionBaseWidth")
        self.XML_element_ChannelSettings.append("UpperRegionBaseWidth")
        self.XML_element_ChannelSettings.append("CompoundCSChannelWidthLimit")
        self.XML_element_ChannelSettings.append("BankSideSlopeRight")
        self.XML_element_ChannelSettings.append("BankSideSlopeLeft")
