# -*- coding: utf-8 -*-

from qgis.PyQt.QtCore import Qt
from qgis.PyQt.QtWidgets import QDialog, QGridLayout, QLabel


class LoadingDialog(QDialog):
    def __init__(self, title, parent=None):
        super(LoadingDialog, self).__init__(parent)
        self.setupUI(title)

    def setupUI(self, title):
        self.setWindowFlags(Qt.Window | Qt.WindowTitleHint | Qt.CustomizeWindowHint)

        w = 400
        h = 100
        self.setFixedSize(w, h)

        self.setWindowTitle(title)
        self.label1 = QLabel()
        self.label2 = QLabel()

        layout = QGridLayout()
        layout.addWidget(self.label1, 0, 0)
        layout.addWidget(self.label2, 1, 0)

        self.setLayout(layout)

    def setLabel(self, msg, target):
        if target:
            self.label1.setText(msg)
        else:
            self.label2.setText(msg)

    def closeEvent(self, e):
        self.setLabel("", True)
        self.setLabel("", False)
